/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.internal;

import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;

public enum RelationType implements Condition<TitanRelation>
{
    EDGE,
    PROPERTY,
    RELATION;


    public boolean isProper() {
        switch (this) {
            case EDGE: 
            case PROPERTY: {
                return true;
            }
            case RELATION: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unrecognized type: " + this));
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.LITERAL;
    }

    @Override
    public Iterable getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public int numChildren() {
        return 0;
    }

    @Override
    public boolean evaluate(TitanRelation relation) {
        switch (this) {
            case EDGE: {
                return relation.isEdge();
            }
            case PROPERTY: {
                return relation.isProperty();
            }
            case RELATION: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unrecognized type: " + this));
    }
}

