/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.idmanagement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.idmanagement.IDInspector;

public class IDManager {
    public static final int TYPE_LEN_RESERVE = 2;
    private static final long TOTAL_BITS = 63L;
    private static final long MAX_PARTITION_BITS = 31L;
    private static final long DEFAULT_PARTITION_BITS = 0L;
    private static final long MAX_TITAN_TYPE_ID = (1L << (int)(63L - IDType.EdgeLabel.offset() - 2L)) - 1L;
    private final long partitionBits;
    private final long partitionOffset;
    private final long maxPartitionID;
    private final long maxRelationID;
    private final long maxVertexID;
    private final IDInspector inspector = new IDInspector(){

        @Override
        public final boolean isRelationID(long id) {
            return IDManager.isRelationID(id);
        }

        @Override
        public final boolean isTypeID(long id) {
            return IDManager.isTypeID(id);
        }

        @Override
        public final boolean isEdgeLabelID(long id) {
            return IDManager.isEdgeLabelID(id);
        }

        @Override
        public final boolean isPropertyKeyID(long id) {
            return IDManager.isPropertyKeyID(id);
        }

        @Override
        public final boolean isVertexID(long id) {
            return IDManager.isVertexID(id);
        }

        @Override
        public final long getPartitionID(long id) {
            return IDManager.this.getPartitionID(id);
        }
    };

    public IDManager(long partitionBits) {
        Preconditions.checkArgument((partitionBits >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionBits <= 31L ? 1 : 0) != 0, (String)"Partition bits can be at most %s bits", (Object[])new Object[]{31L});
        this.partitionBits = partitionBits;
        this.maxPartitionID = (1L << (int)partitionBits) - 1L;
        this.maxRelationID = (1L << (int)(63L - partitionBits - IDType.Relation.offset())) - 1L;
        this.maxVertexID = (1L << (int)(63L - partitionBits - IDType.Vertex.offset())) - 1L;
        this.partitionOffset = 63L - partitionBits;
    }

    public IDManager() {
        this(0L);
    }

    private static long prefixWithOffset(long id, long prefixid, long prefixOffset, long maxPrefixID) {
        assert (maxPrefixID >= 0L && prefixOffset < 64L);
        if (id < 0L) {
            throw new IllegalArgumentException("ID cannot be negative: " + id);
        }
        if (prefixid < 0L) {
            throw new IllegalArgumentException("Prefix ID cannot be negative: " + prefixid);
        }
        if (prefixid == 0L) {
            return id;
        }
        if (prefixid > maxPrefixID) {
            throw new IllegalArgumentException("Prefix ID exceeds limit of: " + maxPrefixID);
        }
        assert (id < 1L << (int)prefixOffset) : "ID is too large for prefix offset: " + id + " ( " + prefixOffset + " )";
        return prefixid << (int)prefixOffset | id;
    }

    private long addPartition(long id, long partitionID) {
        assert (id > 0L);
        assert (partitionID >= 0L);
        return IDManager.prefixWithOffset(id, partitionID, this.partitionOffset, this.maxPartitionID);
    }

    public long getRelationID(long count, long partition) {
        if (count < 0L || count > this.maxRelationID) {
            throw new IllegalArgumentException("Invalid count for bound:" + this.maxRelationID);
        }
        return this.addPartition(IDType.Relation.addPadding(count), partition);
    }

    public long getVertexID(long count, long partition) {
        if (count < 0L || count > this.maxVertexID) {
            throw new IllegalArgumentException("Invalid count for bound:" + this.maxVertexID);
        }
        return this.addPartition(IDType.Vertex.addPadding(count), partition);
    }

    public static long getEdgeLabelID(long count) {
        assert (count > 0L && count < MAX_TITAN_TYPE_ID);
        return IDType.EdgeLabel.addPadding(count);
    }

    public static long getPropertyKeyID(long count) {
        Preconditions.checkArgument((count > 0L && count < MAX_TITAN_TYPE_ID ? 1 : 0) != 0, (String)"Invalid count [%s] for bound: %s", (Object[])new Object[]{count, MAX_TITAN_TYPE_ID});
        if (count < 0L || count > MAX_TITAN_TYPE_ID) {
            throw new IllegalArgumentException("Invalid count for bound:" + MAX_TITAN_TYPE_ID);
        }
        return IDType.PropertyKey.addPadding(count);
    }

    public static long getTypeCount(long typeid) {
        Preconditions.checkArgument((boolean)IDType.TitanType.is(typeid));
        return IDType.EdgeLabel.removePadding(typeid);
    }

    public long getMaxRelationCount() {
        return this.maxRelationID;
    }

    public long getMaxTitanTypeCount() {
        return MAX_TITAN_TYPE_ID;
    }

    public long getMaxVertexCount() {
        return this.maxVertexID;
    }

    public long getMaxPartitionCount() {
        return this.maxPartitionID;
    }

    public long getPartitionID(long id) {
        Preconditions.checkArgument((!IDType.TitanType.is(id) ? 1 : 0) != 0, (String)"Types don't have a partition: %s", (Object[])new Object[]{id});
        return id >>> (int)this.partitionOffset;
    }

    public long isolatePartitionID(long id) {
        return this.getPartitionID(id) << (int)this.partitionOffset;
    }

    public static final boolean isVertexID(long id) {
        return IDType.Vertex.is(id);
    }

    public static final boolean isTypeID(long id) {
        return IDType.TitanType.is(id);
    }

    public static final boolean isPropertyKeyID(long id) {
        return IDType.PropertyKey.is(id);
    }

    public static final boolean isEdgeLabelID(long id) {
        return IDType.EdgeLabel.is(id);
    }

    public static final boolean isRelationID(long id) {
        return IDType.Relation.is(id);
    }

    public IDInspector getIDInspector() {
        return this.inspector;
    }

    public static enum IDType {
        Relation{

            @Override
            public final long offset() {
                return 1L;
            }

            @Override
            public final long id() {
                return 1L;
            }
        }
        ,
        TitanType{

            @Override
            public final long offset() {
                return 2L;
            }

            @Override
            public final long id() {
                return 2L;
            }
        }
        ,
        PropertyKey{

            @Override
            public final long offset() {
                return 3L;
            }

            @Override
            public final long id() {
                return 2L;
            }
        }
        ,
        EdgeLabel{

            @Override
            public final long offset() {
                return 3L;
            }

            @Override
            public final long id() {
                return 6L;
            }
        }
        ,
        Vertex{

            @Override
            public final long offset() {
                return 2L;
            }

            @Override
            public final long id() {
                return 0L;
            }
        };


        public abstract long offset();

        public abstract long id();

        public final long addPadding(long id) {
            return id << (int)this.offset() | this.id();
        }

        public final long removePadding(long id) {
            return id >>> (int)this.offset();
        }

        public final boolean is(long id) {
            return (id & (1L << (int)this.offset()) - 1L) == this.id();
        }
    }
}

