/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.thinkaurelius.titan.core.AttributeHandler;
import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.DefaultAttributeHandling;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.SerializerInitialization;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoAttributeSerializerAdapter;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoDataOutput;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KryoSerializer
extends DefaultAttributeHandling
implements Serializer {
    private static final int MAX_OUTPUT_SIZE = 0xA00000;
    private final boolean registerRequired;
    private final ThreadLocal<Kryo> kryos;
    private final Map<Integer, TypeRegistration> registrations;
    private static final StaticBuffer.Factory<Input> INPUT_FACTORY = new StaticBuffer.Factory<Input>(){

        @Override
        public Input get(byte[] array, int offset, int limit) {
            return new Input(Arrays.copyOfRange(array, offset, limit));
        }
    };
    private boolean initialized = false;
    private final Cache<Class<?>, Boolean> objectVerificationCache = CacheBuilder.newBuilder().maximumSize(10000L).concurrencyLevel(4).initialCapacity(32).build();

    public KryoSerializer(boolean allowAllSerializable) {
        this.registerRequired = !allowAllSerializable;
        this.registrations = new HashMap<Integer, TypeRegistration>();
        this.kryos = new ThreadLocal<Kryo>(){

            @Override
            public Kryo initialValue() {
                KryoSerializer.this.initialized = true;
                Kryo k = new Kryo();
                k.setRegistrationRequired(KryoSerializer.this.registerRequired);
                k.register(Class.class, (com.esotericsoftware.kryo.Serializer)new DefaultSerializers.ClassSerializer());
                for (Map.Entry entry : KryoSerializer.this.registrations.entrySet()) {
                    if (((TypeRegistration)entry.getValue()).serializer == null) {
                        k.register(((TypeRegistration)entry.getValue()).type, ((Integer)entry.getKey()).intValue());
                        continue;
                    }
                    k.register(((TypeRegistration)entry.getValue()).type, ((TypeRegistration)entry.getValue()).serializer, ((Integer)entry.getKey()).intValue());
                }
                return k;
            }
        };
        SerializerInitialization.initialize(this);
    }

    @Override
    public synchronized <T> void registerClass(Class<T> type, int id) {
        Preconditions.checkArgument((!this.initialized ? 1 : 0) != 0, (Object)"Serializer has already been initialized!");
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (String)"Invalid id provided: %s", (Object[])new Object[]{id});
        Preconditions.checkArgument((!this.registrations.containsKey(id) ? 1 : 0) != 0, (String)"ID has already been registered: %s", (Object[])new Object[]{id});
        Preconditions.checkArgument((boolean)KryoSerializer.isValidClass(type), (String)"Class does not have a default constructor: %s", (Object[])new Object[]{type.getName()});
        this.registrations.put(id, new TypeRegistration(type, null));
        this.objectVerificationCache.put(type, (Object)Boolean.TRUE);
    }

    @Override
    public <T> void registerClass(Class<T> type, AttributeHandler<T> handler, int id) {
        super.registerClass(type, handler);
        this.registerClass(type, id);
    }

    @Override
    public synchronized <T> void registerClass(Class<T> type, AttributeSerializer<T> serializer, int id) {
        super.registerClass(type, serializer);
        Preconditions.checkArgument((!this.initialized ? 1 : 0) != 0, (Object)"Serializer has already been initialized!");
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (String)"Invalid id provided: %s", (Object[])new Object[]{id});
        Preconditions.checkArgument((!this.registrations.containsKey(id) ? 1 : 0) != 0, (String)"ID has already been registered: %s", (Object[])new Object[]{id});
        this.registrations.put(id, new TypeRegistration(type, new KryoAttributeSerializerAdapter<T>(serializer)));
        this.objectVerificationCache.put(type, (Object)Boolean.TRUE);
    }

    Kryo getKryo() {
        return this.kryos.get();
    }

    @Override
    public Object readClassAndObject(ReadBuffer buffer) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readClassAndObject(i);
        buffer.movePosition(i.position() - startPos);
        return value;
    }

    @Override
    public <T> T readObject(ReadBuffer buffer, Class<T> type) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readObjectOrNull(i, type);
        buffer.movePosition(i.position() - startPos);
        return (T)value;
    }

    @Override
    public <T> T readObjectNotNull(ReadBuffer buffer, Class<T> type) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readObject(i, type);
        buffer.movePosition(i.position() - startPos);
        return (T)value;
    }

    @Override
    public DataOutput getDataOutput(int capacity, boolean serializeObjects) {
        Output output = new Output(capacity, 0xA00000);
        if (serializeObjects) {
            return new KryoDataOutput(output, this);
        }
        return new KryoDataOutput(output);
    }

    final boolean isValidObject(Kryo kryo, Object o) {
        if (o == null) {
            return true;
        }
        Boolean status = (Boolean)this.objectVerificationCache.getIfPresent(o.getClass());
        if (status == null) {
            if (!(kryo.getSerializer(o.getClass()) instanceof FieldSerializer)) {
                status = Boolean.TRUE;
            } else if (!KryoSerializer.isValidClass(o.getClass())) {
                status = Boolean.FALSE;
            } else {
                try {
                    Output out = new Output(128, 0xA00000);
                    kryo.writeClassAndObject(out, o);
                    Input in = new Input(out.getBuffer(), 0, out.position());
                    Object ocopy = kryo.readClassAndObject(in);
                    status = o.equals(ocopy) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable e) {
                    status = Boolean.FALSE;
                }
            }
            this.objectVerificationCache.put(o.getClass(), (Object)status);
        }
        return status;
    }

    public static final boolean isValidClass(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isArray()) {
            return KryoSerializer.isValidClass(type.getComponentType());
        }
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static class TypeRegistration {
        final Class type;
        final com.esotericsoftware.kryo.Serializer serializer;

        TypeRegistration(Class type, com.esotericsoftware.kryo.Serializer serializer) {
            this.type = type;
            this.serializer = serializer;
        }
    }
}

