/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.InputScanBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoDataOutput;

public class KryoAttributeSerializerAdapter<T>
extends Serializer<T> {
    private final AttributeSerializer<T> serializer;

    KryoAttributeSerializerAdapter(AttributeSerializer<T> serializer) {
        Preconditions.checkNotNull(serializer);
        this.serializer = serializer;
    }

    public T read(Kryo kryo, Input in, Class<T> type) {
        return this.serializer.read(new InputScanBuffer(in));
    }

    public void write(Kryo kryo, Output output, T o) {
        this.serializer.writeObjectData(new KryoDataOutput(output), o);
    }
}

