/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.CharacterSerializer;

public class StringSerializer
implements AttributeSerializer<String> {
    private final CharacterSerializer cs = new CharacterSerializer();

    @Override
    public String read(ScanBuffer buffer) {
        char c;
        StringBuilder s = new StringBuilder();
        while ((c = this.cs.read(buffer).charValue()) > '\u0000') {
            s.append(c);
        }
        return s.toString();
    }

    @Override
    public void writeObjectData(WriteBuffer buffer, String attribute) {
        for (int i = 0; i < attribute.length(); ++i) {
            char c = attribute.charAt(i);
            Preconditions.checkArgument((c > '\u0000' ? 1 : 0) != 0, (String)"No null characters allowed in string @ position %s: %s", (Object[])new Object[]{i, attribute});
            this.cs.writeObjectData(buffer, Character.valueOf(c));
        }
        this.cs.writeObjectData(buffer, Character.valueOf('\u0000'));
    }

    @Override
    public void verifyAttribute(String value) {
        for (int i = 0; i < value.length(); ++i) {
            Preconditions.checkArgument((value.charAt(i) > '\u0000' ? 1 : 0) != 0, (String)"No null characters allowed in string @ position %s: %s", (Object[])new Object[]{i, value});
        }
    }

    @Override
    public String convert(Object value) {
        Preconditions.checkNotNull((Object)value);
        return value.toString();
    }
}

