/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.ShortSerializer;

public class CharacterSerializer
implements AttributeSerializer<Character> {
    private final ShortSerializer ss = new ShortSerializer();

    @Override
    public Character read(ScanBuffer buffer) {
        short s = this.ss.read(buffer);
        return Character.valueOf(CharacterSerializer.short2char(s));
    }

    @Override
    public void writeObjectData(WriteBuffer out, Character attribute) {
        this.ss.writeObjectData(out, CharacterSerializer.char2short(attribute.charValue()));
    }

    public static final short char2short(char c) {
        return (short)(c + Short.MIN_VALUE);
    }

    public static final char short2char(short s) {
        return (char)(s - Short.MIN_VALUE);
    }

    @Override
    public void verifyAttribute(Character value) {
    }

    @Override
    public Character convert(Object value) {
        if (value instanceof String && ((String)value).length() == 1) {
            return Character.valueOf(((String)value).charAt(0));
        }
        return null;
    }
}

