/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeHandler;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import java.util.HashMap;
import java.util.Map;

public class DefaultAttributeHandling
implements AttributeHandling {
    private final Map<Class, AttributeHandler> handlers = new HashMap<Class, AttributeHandler>(50);

    public <V> void registerClass(Class<V> datatype, AttributeHandler<V> handler) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull(handler);
        Preconditions.checkArgument((!this.handlers.containsKey(datatype) ? 1 : 0) != 0, (String)"DataType has already been registered: %s", (Object[])new Object[]{datatype});
        this.handlers.put(datatype, handler);
    }

    @Override
    public <V> void verifyAttribute(Class<V> datatype, Object value) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull((Object)value);
        AttributeHandler handler = this.handlers.get(datatype);
        if (handler != null) {
            handler.verifyAttribute(value);
        }
    }

    @Override
    public <V> V convert(Class<V> datatype, Object value) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull((Object)value);
        AttributeHandler handler = this.handlers.get(datatype);
        if (handler != null) {
            return handler.convert(value);
        }
        return null;
    }
}

