/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idhandling;

import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;

public class VariableLong {
    private static final byte BIT_MASK = 127;
    private static final byte STOP_MASK = -128;

    public static int unsignedByte(byte b) {
        return b < 0 ? b + 256 : b;
    }

    private static long readUnsigned(ReadBuffer in) {
        byte b;
        long value = 0L;
        do {
            b = in.getByte();
            value = value << 7 | (long)(b & 0x7F);
        } while (b >= 0);
        return value;
    }

    private static void writeUnsigned(WriteBuffer out, long value) {
        VariableLong.writeUnsigned(out, VariableLong.unsignedBlockBitLength(value), value);
    }

    private static void writeUnsigned(WriteBuffer out, int offset, long value) {
        assert (offset % 7 == 0);
        while (offset > 0) {
            byte b = (byte)(value >>> (offset -= 7) & 0x7FL);
            if (offset == 0) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.putByte(b);
        }
    }

    private static int unsignedBlockBitLength(long value) {
        return VariableLong.unsignedNumBlocks(value) * 7;
    }

    private static int unsignedNumBlocks(long value) {
        return VariableLong.numVariableBlocks(VariableLong.unsignedBitLength(value));
    }

    private static int numVariableBlocks(int numBits) {
        assert (numBits > 0);
        return (numBits - 1) / 7 + 1;
    }

    public static int unsignedBitLength(long value) {
        return value == 0L ? 1 : 64 - Long.numberOfLeadingZeros(value);
    }

    public static long readPositive(ReadBuffer in) {
        long value = VariableLong.readUnsigned(in);
        assert (value >= 0L);
        return value;
    }

    public static void writePositive(WriteBuffer out, long value) {
        assert (value >= 0L);
        VariableLong.writeUnsigned(out, value);
    }

    public static StaticBuffer positiveByteBuffer(long value) {
        WriteByteBuffer buffer = new WriteByteBuffer(VariableLong.positiveLength(value));
        VariableLong.writePositive(buffer, value);
        return buffer.getStaticBuffer();
    }

    public static StaticBuffer positiveByteBuffer(long[] value) {
        int len = 0;
        for (long aValue : value) {
            len += VariableLong.positiveLength(aValue);
        }
        WriteByteBuffer buffer = new WriteByteBuffer(len);
        for (long aValue : value) {
            VariableLong.writePositive(buffer, aValue);
        }
        return buffer.getStaticBuffer();
    }

    public static int positiveLength(long value) {
        assert (value >= 0L);
        return VariableLong.unsignedNumBlocks(value);
    }

    private static long convert2Unsigned(long value) {
        assert (value >= 0L || value > Long.MIN_VALUE);
        return Math.abs(value) << 1 | (long)(value < 0L ? 1 : 0);
    }

    private static long convertFromUnsigned(long value) {
        return (value & 1L) == 1L ? -(value >>> 1) : value >>> 1;
    }

    public static int length(long value) {
        return VariableLong.unsignedNumBlocks(VariableLong.convert2Unsigned(value));
    }

    public static void write(WriteBuffer out, long value) {
        VariableLong.writeUnsigned(out, VariableLong.convert2Unsigned(value));
    }

    public static long read(ReadBuffer in) {
        return VariableLong.convertFromUnsigned(VariableLong.readUnsigned(in));
    }

    public static void writePositiveWithPrefix(WriteBuffer out, long value, long prefix, int prefixBitLen) {
        assert (value >= 0L);
        assert (prefixBitLen > 0 && prefixBitLen < 6 && prefix < 1L << prefixBitLen);
        int deltaLen = 8 - prefixBitLen;
        byte first = (byte)(prefix << deltaLen);
        int valueLen = VariableLong.unsignedBitLength(value);
        int mod = valueLen % 7;
        if (mod <= deltaLen - 1) {
            int offset = valueLen - mod;
            first = (byte)((long)first | value >>> offset);
            value &= (1L << offset) - 1L;
            valueLen -= mod;
        } else {
            valueLen += 7 - mod;
        }
        if (valueLen == 0) {
            first = (byte)(first | 1 << deltaLen - 1);
        }
        out.putByte(first);
        if (valueLen > 0) {
            VariableLong.writeUnsigned(out, valueLen, value);
        }
    }

    public static int positiveWithPrefixLength(long value, int prefixBitLen) {
        assert (value >= 0L);
        assert (prefixBitLen > 0 && prefixBitLen < 6);
        return VariableLong.numVariableBlocks(VariableLong.unsignedBitLength(value) + prefixBitLen);
    }

    public static long[] readPositiveWithPrefix(ReadBuffer in, int prefixBitLen) {
        assert (prefixBitLen > 0 && prefixBitLen < 6);
        int first = VariableLong.unsignedByte(in.getByte());
        int deltaLen = 8 - prefixBitLen;
        long prefix = first >> deltaLen;
        long value = first & (1 << deltaLen - 1) - 1;
        if ((first >>> deltaLen - 1 & 1) == 0) {
            int deltaPos = in.getPosition();
            long remainder = VariableLong.readUnsigned(in);
            deltaPos = in.getPosition() - deltaPos;
            assert (deltaPos > 0);
            value = (value << deltaPos * 7) + remainder;
        }
        return new long[]{value, prefix};
    }

    public static void writePositiveBackward(WriteBuffer out, long value) {
        assert (value >= 0L);
        VariableLong.writeUnsignedBackward(out, value);
    }

    public static long readPositiveBackward(ReadBuffer in) {
        return VariableLong.readUnsignedBackward(in);
    }

    public static void writeBackward(WriteBuffer out, long value) {
        VariableLong.writeUnsignedBackward(out, VariableLong.convert2Unsigned(value));
    }

    public static long readBackward(ReadBuffer in) {
        return VariableLong.convertFromUnsigned(VariableLong.readUnsignedBackward(in));
    }

    private static void writeUnsignedBackward(WriteBuffer out, long value) {
        boolean first = true;
        do {
            byte b = (byte)(value & 0x7FL);
            value >>>= 7;
            if (first) {
                b = (byte)(b | 0xFFFFFF80);
                first = false;
            }
            out.putByte(b);
        } while (value > 0L);
    }

    private static long readUnsignedBackward(ReadBuffer in) {
        byte b;
        int position = in.getPosition();
        long value = 0L;
        do {
            b = in.getByte(position);
            value = value << 7 | (long)(b & 0x7F);
            --position;
        } while (b >= 0);
        in.movePosition(position - in.getPosition());
        return value;
    }
}

