/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner.placement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.IDPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionAssignment;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimplePartitionAssignment;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import java.util.Map;
import java.util.Random;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBulkPlacementStrategy
implements IDPlacementStrategy {
    private static final Logger log = LoggerFactory.getLogger(SimpleBulkPlacementStrategy.class);
    public static final String CONCURRENT_PARTITIONS_KEY = "num-partitions";
    public static final int CONCURRENT_PARTITIONS_DEFAULT = 10;
    private final Random random = new Random();
    private final int[] currentPartitions;
    private int lowerPartitionID = -1;
    private int partitionWidth = -1;
    private int idCeiling = -1;

    public SimpleBulkPlacementStrategy(int concurrentPartitions) {
        Preconditions.checkArgument((concurrentPartitions > 0 ? 1 : 0) != 0);
        this.currentPartitions = new int[concurrentPartitions];
    }

    public SimpleBulkPlacementStrategy(Configuration config) {
        this(config.getInt(CONCURRENT_PARTITIONS_KEY, 10));
    }

    private final int nextPartitionID() {
        return this.currentPartitions[this.random.nextInt(this.currentPartitions.length)];
    }

    private final void updateElement(int index) {
        Preconditions.checkArgument((this.lowerPartitionID >= 0 && this.partitionWidth > 0 && this.idCeiling > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((index >= 0 && index < this.currentPartitions.length ? 1 : 0) != 0);
        this.currentPartitions[index] = (this.random.nextInt(this.partitionWidth) + this.lowerPartitionID) % this.idCeiling;
    }

    @Override
    public int getPartition(InternalElement vertex) {
        return this.nextPartitionID();
    }

    @Override
    public void getPartitions(Map<InternalVertex, PartitionAssignment> vertices) {
        int partitionID = this.nextPartitionID();
        for (Map.Entry<InternalVertex, PartitionAssignment> entry : vertices.entrySet()) {
            entry.setValue(new SimplePartitionAssignment(partitionID));
        }
    }

    @Override
    public boolean supportsBulkPlacement() {
        return true;
    }

    @Override
    public void setLocalPartitionBounds(int lowerID, int upperID, int idLimit) {
        Preconditions.checkArgument((idLimit > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((lowerID >= 0 && lowerID < idLimit ? 1 : 0) != 0, (Object)lowerID);
        Preconditions.checkArgument((upperID >= 0 && upperID <= idLimit ? 1 : 0) != 0, (Object)upperID);
        this.lowerPartitionID = lowerID;
        this.idCeiling = idLimit;
        this.partitionWidth = lowerID < upperID ? upperID - this.lowerPartitionID : idLimit - lowerID + upperID;
        Preconditions.checkArgument((this.partitionWidth > 0 ? 1 : 0) != 0, (Object)this.partitionWidth);
        for (int i = 0; i < this.currentPartitions.length; ++i) {
            this.updateElement(i);
        }
    }

    @Override
    public void exhaustedPartition(int partitionID) {
        boolean found = false;
        for (int i = 0; i < this.currentPartitions.length; ++i) {
            if (this.currentPartitions[i] != partitionID) continue;
            this.updateElement(i);
            found = true;
        }
    }
}

