/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPool;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIDPool
implements IDPool {
    private static final Logger log = LoggerFactory.getLogger(StandardIDPool.class);
    private static final long BUFFER_EMPTY = -1L;
    private static final long BUFFER_POOL_EXHAUSTION = -100L;
    private static final int RENEW_ID_COUNT = 100;
    private static final long RENEW_WAIT_INTERVAL = 1000L;
    private final IDAuthority idAuthority;
    private final long maxID;
    private final int partitionID;
    private final long renewTimeoutMS;
    private final double renewBufferPercentage;
    private long nextID;
    private long currentMaxID;
    private long renewBufferID;
    private volatile long bufferNextID;
    private volatile long bufferMaxID;
    private Thread idBlockRenewer;
    private boolean initialized;

    public StandardIDPool(IDAuthority idAuthority, long partitionID, long maximumID, long renewTimeoutMS, double renewBufferPercentage) {
        Preconditions.checkArgument((maximumID > 0L ? 1 : 0) != 0);
        this.idAuthority = idAuthority;
        Preconditions.checkArgument((partitionID < 0x100000000L ? 1 : 0) != 0);
        this.partitionID = (int)partitionID;
        this.maxID = maximumID;
        Preconditions.checkArgument((renewTimeoutMS > 0L ? 1 : 0) != 0, (Object)"Renew-timeout must be positive");
        this.renewTimeoutMS = renewTimeoutMS;
        Preconditions.checkArgument((renewBufferPercentage > 0.0 && renewBufferPercentage <= 1.0 ? 1 : 0) != 0, (Object)"Renew-buffer percentage must be in (0.0,1.0]");
        this.renewBufferPercentage = renewBufferPercentage;
        this.nextID = 0L;
        this.currentMaxID = 0L;
        this.renewBufferID = 0L;
        this.bufferNextID = -1L;
        this.bufferMaxID = -1L;
        this.idBlockRenewer = null;
        this.initialized = false;
    }

    private void waitForIDRenewer() throws InterruptedException {
        long timeStart = System.currentTimeMillis();
        long timeDelta = 0L;
        while (this.idBlockRenewer != null && this.idBlockRenewer.isAlive() && (timeDelta = System.currentTimeMillis() - timeStart) < this.renewTimeoutMS) {
            if (timeDelta < 1000L) {
                log.debug("Waiting for id renewal thread on partition {} [{} ms]", (Object)this.partitionID, (Object)timeDelta);
            } else {
                log.warn("Waiting for id renewal thread on partition {} [{} ms]", (Object)this.partitionID, (Object)timeDelta);
            }
            this.idBlockRenewer.join(1000L);
        }
        if (this.idBlockRenewer != null && this.idBlockRenewer.isAlive()) {
            throw new TitanException("ID renewal thread on partition [" + this.partitionID + "] did not complete in time. [" + (System.currentTimeMillis() - timeStart) + " ms]");
        }
    }

    private synchronized void nextBlock() throws InterruptedException {
        assert (this.nextID == this.currentMaxID);
        this.waitForIDRenewer();
        if (this.bufferMaxID == -100L || this.bufferNextID == -100L) {
            throw new IDPoolExhaustedException("Exhausted ID Pool for partition: " + this.partitionID);
        }
        Preconditions.checkArgument((this.bufferMaxID > 0L ? 1 : 0) != 0, (Object)this.bufferMaxID);
        Preconditions.checkArgument((this.bufferNextID > 0L ? 1 : 0) != 0, (Object)this.bufferNextID);
        this.nextID = this.bufferNextID;
        this.currentMaxID = this.bufferMaxID;
        log.debug("[ID Partition {}] Acquired range: [{},{}]", new Object[]{this.partitionID, this.nextID, this.currentMaxID});
        assert (this.nextID > 0L && this.currentMaxID > this.nextID);
        this.bufferNextID = -1L;
        this.bufferMaxID = -1L;
        this.renewBufferID = this.currentMaxID - Math.max(100L, Math.round((double)(this.currentMaxID - this.nextID) * this.renewBufferPercentage));
        if (this.renewBufferID >= this.currentMaxID) {
            this.renewBufferID = this.currentMaxID - 1L;
        }
        if (this.renewBufferID < this.nextID) {
            this.renewBufferID = this.nextID;
        }
        assert (this.renewBufferID >= this.nextID && this.renewBufferID < this.currentMaxID);
    }

    private void renewBuffer() {
        Preconditions.checkArgument((this.bufferNextID == -1L ? 1 : 0) != 0, (Object)this.bufferNextID);
        Preconditions.checkArgument((this.bufferMaxID == -1L ? 1 : 0) != 0, (Object)this.bufferMaxID);
        try {
            long[] idblock = this.idAuthority.getIDBlock(this.partitionID);
            this.bufferNextID = idblock[0];
            this.bufferMaxID = idblock[1];
            Preconditions.checkArgument((this.bufferNextID > 0L ? 1 : 0) != 0, (Object)this.bufferNextID);
            Preconditions.checkArgument((this.bufferMaxID > this.bufferNextID ? 1 : 0) != 0, (Object)this.bufferMaxID);
        }
        catch (StorageException e) {
            throw new TitanException("Could not acquire new ID block from storage", e);
        }
        catch (IDPoolExhaustedException e) {
            this.bufferNextID = -100L;
            this.bufferMaxID = -100L;
        }
    }

    @Override
    public synchronized long nextID() {
        long returnId;
        assert (this.nextID <= this.currentMaxID);
        if (!this.initialized) {
            this.startNextIDAcquisition();
            this.initialized = true;
        }
        if (this.nextID == this.currentMaxID) {
            try {
                this.nextBlock();
            }
            catch (InterruptedException e) {
                throw new TitanException("Could not renew id block due to interruption", e);
            }
        }
        if (this.nextID == this.renewBufferID) {
            this.startNextIDAcquisition();
        }
        if ((returnId = this.nextID++) > this.maxID) {
            throw new IDPoolExhaustedException("Exhausted max id of " + this.maxID);
        }
        log.trace("[{}] Returned id: {}", (Object)this.partitionID, (Object)returnId);
        return returnId;
    }

    @Override
    public synchronized void close() {
        try {
            this.waitForIDRenewer();
        }
        catch (InterruptedException e) {
            throw new TitanException("Interrupted while waiting for id renewer thread to finish", e);
        }
    }

    private void startNextIDAcquisition() {
        Preconditions.checkArgument((this.idBlockRenewer == null || !this.idBlockRenewer.isAlive() ? 1 : 0) != 0, (Object)this.idBlockRenewer);
        log.debug("Starting id block renewal thread upon {}", (Object)this.nextID);
        this.idBlockRenewer = new IDBlockThread();
        this.idBlockRenewer.start();
    }

    private class IDBlockThread
    extends Thread {
        private IDBlockThread() {
        }

        @Override
        public void run() {
            StandardIDPool.this.renewBuffer();
            log.debug("Finishing id renewal thread");
        }
    }
}

