/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.TitanFactory;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class TitanConstants {
    public static final String TITAN_PROPERTIES_FILE = "titan.properties";
    public static final String VERSION;
    public static final List<String> COMPATIBLE_VERSIONS;

    static {
        Properties props;
        try {
            props = new Properties();
            props.load(TitanFactory.class.getClassLoader().getResourceAsStream(TITAN_PROPERTIES_FILE));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        VERSION = props.getProperty("titan.version");
        ImmutableList.Builder b = ImmutableList.builder();
        for (String v : props.getProperty("titan.compatible-versions", "").split(",")) {
            if ((v = v.trim()).isEmpty()) continue;
            b.add((Object)v);
        }
        COMPATIBLE_VERSIONS = b.build();
    }
}

