/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.thinkaurelius.titan.core.AttributeHandler;
import com.thinkaurelius.titan.core.DefaultTypeMaker;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.graphdb.blueprints.BlueprintsDefaultTypeMaker;
import com.thinkaurelius.titan.graphdb.configuration.RegisteredAttributeClass;
import com.thinkaurelius.titan.graphdb.database.cache.ExpirationStoreCache;
import com.thinkaurelius.titan.graphdb.database.cache.PassThroughStoreCache;
import com.thinkaurelius.titan.graphdb.database.cache.StoreCache;
import com.thinkaurelius.titan.graphdb.database.idassigner.VertexIDAssigner;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoSerializer;
import com.thinkaurelius.titan.graphdb.types.DisableDefaultTypeMaker;
import com.thinkaurelius.titan.util.stats.MetricManager;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GraphDatabaseConfiguration.class);
    public static final String AUTO_TYPE_KEY = "autotype";
    public static final String AUTO_TYPE_DEFAULT = "blueprints";
    private static final Map<String, DefaultTypeMaker> preregisteredAutoType = new HashMap<String, DefaultTypeMaker>(){
        {
            this.put("none", DisableDefaultTypeMaker.INSTANCE);
            this.put(GraphDatabaseConfiguration.AUTO_TYPE_DEFAULT, BlueprintsDefaultTypeMaker.INSTANCE);
        }
    };
    public static final String PROPERTY_PREFETCHING_KEY = "fast-property";
    public static final String ALLOW_SETTING_VERTEX_ID_KEY = "set-vertex-id";
    public static final boolean ALLOW_SETTING_VERTEX_ID_DEFAULT = false;
    public static final String IGNORE_UNKNOWN_INDEX_FIELD_KEY = "ignore-unknown-index-key";
    public static final boolean IGNORE_UNKNOWN_INDEX_FIELD_DEFAULT = false;
    public static final String UKNOWN_FIELD_NAME = "unknown_key";
    public static final String CACHE_NAMESPACE = "cache";
    public static final String DB_CACHE_KEY = "db-cache";
    public static final boolean DB_CACHE_DEFAULT = false;
    public static final String DB_CACHE_SIZE_KEY = "db-cache-size";
    public static final double DB_CACHE_SIZE_DEFAULT = 0.3;
    public static final String DB_CACHE_CLEAN_WAIT_KEY = "db-cache-clean-wait";
    public static final long DB_CACHE_CLEAN_WAIT_DEFAULT = 50L;
    public static final String DB_CACHE_TIME_KEY = "db-cache-time";
    public static final long DB_CACHE_TIME_DEFAULT = 10000L;
    private static final long ETERNAL_CACHE_EXPIRATION = 6307200000000L;
    public static final String TX_CACHE_SIZE_KEY = "tx-cache-size";
    public static final int TX_CACHE_SIZE_DEFAULT = 20000;
    public static final String STORAGE_NAMESPACE = "storage";
    public static final String STORAGE_DIRECTORY_KEY = "directory";
    public static final String STORAGE_CONF_FILE_KEY = "conffile";
    public static final String STORAGE_BACKEND_KEY = "backend";
    public static final String STORAGE_BACKEND_DEFAULT = "local";
    public static final String STORAGE_READONLY_KEY = "read-only";
    public static final boolean STORAGE_READONLY_DEFAULT = false;
    public static final String STORAGE_BATCH_KEY = "batch-loading";
    public static final boolean STORAGE_BATCH_DEFAULT = false;
    public static final String STORAGE_TRANSACTIONAL_KEY = "transactions";
    public static final boolean STORAGE_TRANSACTIONAL_DEFAULT = true;
    public static final String BUFFER_SIZE_KEY = "buffer-size";
    public static final int BUFFER_SIZE_DEFAULT = 1024;
    public static final String WRITE_ATTEMPTS_KEY = "write-attempts";
    public static final int WRITE_ATTEMPTS_DEFAULT = 5;
    public static final String READ_ATTEMPTS_KEY = "read-attempts";
    public static final int READ_ATTEMPTS_DEFAULT = 3;
    public static final String STORAGE_ATTEMPT_WAITTIME_KEY = "attempt-wait";
    public static final int STORAGE_ATTEMPT_WAITTIME_DEFAULT = 250;
    public static final String PARALLEL_BACKEND_OPS_KEY = "parallel-backend-ops";
    public static final boolean PARALLEL_BACKEND_OPS_DEFAULT = true;
    public static final String INSTANCE_RID_RAW_KEY = "machine-id";
    public static final String INSTANCE_RID_SHORT_KEY = "machine-id-appendix";
    public static final String LOCK_RETRY_COUNT = "lock-retries";
    public static final int LOCK_RETRY_COUNT_DEFAULT = 3;
    public static final String LOCK_WAIT_MS = "lock-wait-time";
    public static final long LOCK_WAIT_MS_DEFAULT = 100L;
    public static final String LOCK_EXPIRE_MS = "lock-expiry-time";
    public static final long LOCK_EXPIRE_MS_DEFAULT = 300000L;
    public static final String LOCK_BACKEND = "lock-backend";
    public static final String LOCK_BACKEND_DEFAULT = "consistentkey";
    public static final String IDAUTHORITY_WAIT_MS_KEY = "idauthority-wait-time";
    public static final long IDAUTHORITY_WAIT_MS_DEFAULT = 300L;
    public static final String IDAUTHORITY_RETRY_COUNT_KEY = "idauthority-retries";
    public static final int IDAUTHORITY_RETRY_COUNT_DEFAULT = 20;
    public static final String IDAUTHORITY_UNIQUE_ID_BITS_KEY = "idauthority-uniqueid-bits";
    public static final int IDAUTHORITY_UNIQUE_ID_BITS_DEFAULT = 0;
    public static final String IDAUTHORITY_UNIQUE_ID_KEY = "idauthority-uniqueid";
    public static final int IDAUTHORITY_UNIQUE_ID_DEFAULT = 0;
    public static final String IDAUTHORITY_RANDOMIZE_UNIQUE_ID_KEY = "idauthority-uniqueid-random";
    public static final boolean IDAUTHORITY_RANDOMIZE_UNIQUE_ID_DEFAULT = false;
    public static final String IDAUTHORITY_USE_LOCAL_CONSISTENCY_KEY = "idauthority-local-consistency";
    public static final boolean IDAUTHORITY_USE_LOCAL_CONSISTENCY_DEFAULT = false;
    public static final String HOSTNAME_KEY = "hostname";
    public static final String HOSTNAME_DEFAULT = "127.0.0.1";
    public static final String PORT_KEY = "port";
    public static final String AUTH_USERNAME_KEY = "username";
    public static final String AUTH_PASSWORD_KEY = "password";
    public static final int CONNECTION_TIMEOUT_DEFAULT = 10000;
    public static final String CONNECTION_TIMEOUT_KEY = "connection-timeout";
    public static final int SETUP_WAITTIME_DEFAULT = 60000;
    public static final String SETUP_WAITTIME_KEY = "setup-wait";
    public static final int CONNECTION_POOL_SIZE_DEFAULT = 32;
    public static final String CONNECTION_POOL_SIZE_KEY = "connection-pool-size";
    public static final int PAGE_SIZE_DEFAULT = 100;
    public static final String PAGE_SIZE_KEY = "page-size";
    public static final String IDS_NAMESPACE = "ids";
    public static final String IDS_BLOCK_SIZE_KEY = "block-size";
    public static final int IDS_BLOCK_SIZE_DEFAULT = 10000;
    public static final String IDS_PARTITION_KEY = "partition";
    public static final boolean IDS_PARTITION_DEFAULT = false;
    public static final String IDS_FLUSH_KEY = "flush";
    public static final boolean IDS_FLUSH_DEFAULT = true;
    public static final String IDS_RENEW_TIMEOUT_KEY = "renew-timeout";
    public static final long IDS_RENEW_TIMEOUT_DEFAULT = 60000L;
    public static final String IDS_RENEW_BUFFER_PERCENTAGE_KEY = "renew-percentage";
    public static final double IDS_RENEW_BUFFER_PERCENTAGE_DEFAULT = 0.3;
    public static final String INDEX_NAMESPACE = "index";
    public static final String INDEX_BACKEND_KEY = "backend";
    public static final String INDEX_BACKEND_DEFAULT = "lucene";
    public static final String ATTRIBUTE_NAMESPACE = "attributes";
    public static final String ATTRIBUTE_ALLOW_ALL_SERIALIZABLE_KEY = "allow-all";
    public static final boolean ATTRIBUTE_ALLOW_ALL_SERIALIZABLE_DEFAULT = true;
    private static final String ATTRIBUTE_PREFIX = "attribute";
    private static final String SERIALIZER_PREFIX = "serializer";
    public static final String METRICS_NAMESPACE = "metrics";
    public static final String METRICS_ENABLED = "enabled";
    public static final boolean METRICS_ENABLED_DEFAULT = false;
    public static final String BASIC_METRICS = "enable-basic-metrics";
    public static final boolean BASIC_METRICS_DEFAULT = false;
    public static final String METRICS_PREFIX_KEY = "prefix";
    public static final String METRICS_PREFIX_DEFAULT = "com.thinkaurelius.titan";
    public static final String METRICS_SYSTEM_PREFIX_DEFAULT = "com.thinkaurelius.titan.sys";
    public static final String MERGE_BASIC_METRICS_KEY = "merge-basic-metrics";
    public static final boolean MERGE_BASIC_METRICS_DEFAULT = true;
    public static final String METRICS_CONSOLE_INTERVAL_KEY = "console.interval";
    public static final Long METRICS_CONSOLE_INTERVAL_DEFAULT = null;
    public static final String METRICS_CSV_INTERVAL_KEY = "csv.interval";
    public static final Long METRICS_CSV_INTERVAL_DEFAULT = null;
    public static final String METRICS_CSV_DIR_KEY = "csv.dir";
    public static final String METRICS_CSV_DIR_DEFAULT = null;
    public static final String METRICS_JMX_ENABLED_KEY = "jmx.enabled";
    public static final boolean METRICS_JMX_ENABLED_DEFAULT = false;
    public static final String METRICS_JMX_DOMAIN_KEY = "jmx.domain";
    public static final String METRICS_JMX_DOMAIN_DEFAULT = null;
    public static final String METRICS_JMX_AGENTID_KEY = "jmx.agentid";
    public static final String METRICS_JMX_AGENTID_DEFAULT = null;
    public static final String METRICS_SLF4J_INTERVAL_KEY = "slf4j.interval";
    public static final Long METRICS_SLF4J_INTERVAL_DEFAULT = null;
    public static final String METRICS_SLF4J_LOGGER_KEY = "slf4j.logger";
    public static final String METRICS_SLF4J_LOGGER_DEFAULT = null;
    public static final String GANGLIA_NAMESPACE = "ganglia";
    public static final String GANGLIA_HOST_OR_GROUP_KEY = "hostname";
    public static final String GANGLIA_INTERVAL_KEY = "interval";
    public static final String GANGLIA_PORT = "port";
    public static final int GANGLIA_PORT_DEFAULT = 8649;
    public static final String GANGLIA_ADDRESSING_MODE_KEY = "addressing-mode";
    public static final String GANGLIA_ADDRESSING_MODE_DEFAULT = "unicast";
    public static final String GANGLIA_TTL_KEY = "ttl";
    public static final int GANGLIA_TTL_DEFAULT = 1;
    public static final String GANGLIA_USE_PROTOCOL_31_KEY = "protocol-31";
    public static final boolean GANGLIA_USE_PROTOCOL_31_DEFAULT = true;
    public static final String GANGLIA_UUID_KEY = "uuid";
    public static final UUID GANGLIA_UUID_DEFAULT = null;
    public static final String GANGLIA_SPOOF_KEY = "spoof";
    public static final String GANGLIA_SPOOF_DEFAULT = null;
    public static final String GRAPHITE_NAMESPACE = "graphite";
    public static final String GRAPHITE_HOST_KEY = "hostname";
    public static final String GRAPHITE_INTERVAL_KEY = "interval";
    public static final String GRAPHITE_PORT_KEY = "port";
    public static final int GRAPHITE_PORT_DEFAULT = 2003;
    public static final String GRAPHITE_PREFIX_KEY = "prefix";
    public static final String GRAPHITE_PREFIX_DEFAULT = null;
    private final Configuration configuration;
    private boolean readOnly;
    private boolean flushIDs;
    private boolean batchLoading;
    private int txCacheSize;
    private DefaultTypeMaker defaultTypeMaker;
    private Boolean propertyPrefetching;
    private boolean allowVertexIdSetting;
    private String metricsPrefix;
    private String unknownIndexKeydName;
    private StoreFeatures storeFeatures = null;
    private static final char CONFIGURATION_SEPARATOR = '.';

    public GraphDatabaseConfiguration(String dirOrFile) {
        this(new File(dirOrFile));
    }

    public GraphDatabaseConfiguration(File dirOrFile) {
        this(GraphDatabaseConfiguration.getConfiguration(dirOrFile));
    }

    public GraphDatabaseConfiguration(Configuration config) {
        Preconditions.checkNotNull((Object)config);
        this.configuration = config;
        this.preLoadConfiguration();
    }

    public static final Configuration getConfiguration(File dirOrFile) {
        BaseConfiguration configuration;
        Preconditions.checkNotNull((Object)dirOrFile, (Object)"Need to specify a configuration file or storage directory");
        try {
            if (dirOrFile.isFile()) {
                configuration = new PropertiesConfiguration(dirOrFile);
                File tmpParent = dirOrFile.getParentFile();
                File configParent = null == tmpParent ? new File(System.getProperty("user.dir")) : tmpParent;
                Preconditions.checkNotNull((Object)configParent);
                Preconditions.checkArgument((boolean)configParent.isDirectory());
                final Pattern p = Pattern.compile(Pattern.quote(STORAGE_NAMESPACE) + "\\..*" + "(" + Pattern.quote(STORAGE_DIRECTORY_KEY) + "|" + Pattern.quote(STORAGE_CONF_FILE_KEY) + ")");
                UnmodifiableIterator keysToMangle = Iterators.filter((Iterator)configuration.getKeys(), (Predicate)new Predicate<String>(){

                    public boolean apply(String key) {
                        if (null == key) {
                            return false;
                        }
                        return p.matcher(key).matches();
                    }
                });
                while (keysToMangle.hasNext()) {
                    String k = (String)keysToMangle.next();
                    Preconditions.checkNotNull((Object)k);
                    String s = configuration.getString(k);
                    if (null == s) {
                        log.warn("Configuration key {} has null value", (Object)k);
                        continue;
                    }
                    File storedir = new File(s);
                    if (!storedir.isAbsolute()) {
                        configuration.setProperty(k, (Object)(configParent.getAbsolutePath() + File.separator + s));
                        log.debug("Overwrote relative path for key {}: was {}, now {}", new Object[]{k, s, configuration.getProperty(k)});
                        continue;
                    }
                    log.debug("Loaded absolute path for key {}: {}", (Object)k, (Object)s);
                }
            } else {
                configuration = new BaseConfiguration();
                configuration.setProperty(GraphDatabaseConfiguration.keyInNamespace(STORAGE_NAMESPACE, STORAGE_DIRECTORY_KEY), (Object)dirOrFile.getAbsolutePath());
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Could not load configuration at: " + dirOrFile, e);
        }
        return configuration;
    }

    public static final String toString(Configuration config) {
        StringBuilder s = new StringBuilder();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            s.append(key).append(": ").append(config.getProperty(key)).append("\n");
        }
        return s.toString();
    }

    public static final String getSystemMetricsPrefix() {
        return METRICS_SYSTEM_PREFIX_DEFAULT;
    }

    private void preLoadConfiguration() {
        Configuration storageConfig = this.configuration.subset(STORAGE_NAMESPACE);
        this.readOnly = storageConfig.getBoolean(STORAGE_READONLY_KEY, false);
        this.flushIDs = this.configuration.subset(IDS_NAMESPACE).getBoolean(IDS_FLUSH_KEY, true);
        this.batchLoading = storageConfig.getBoolean(STORAGE_BATCH_KEY, false);
        this.txCacheSize = this.configuration.getInt(TX_CACHE_SIZE_KEY, 20000);
        this.defaultTypeMaker = preregisteredAutoType.get(this.configuration.getString(AUTO_TYPE_KEY, AUTO_TYPE_DEFAULT));
        Preconditions.checkNotNull((Object)this.defaultTypeMaker, (Object)("Invalid autotype option: " + this.configuration.getString(AUTO_TYPE_KEY, AUTO_TYPE_DEFAULT)));
        if (this.batchLoading) {
            this.defaultTypeMaker = DisableDefaultTypeMaker.INSTANCE;
        }
        this.propertyPrefetching = this.configuration.containsKey(PROPERTY_PREFETCHING_KEY) ? Boolean.valueOf(this.configuration.getBoolean(PROPERTY_PREFETCHING_KEY)) : null;
        this.allowVertexIdSetting = this.configuration.getBoolean(ALLOW_SETTING_VERTEX_ID_KEY, false);
        this.unknownIndexKeydName = this.configuration.getBoolean(IGNORE_UNKNOWN_INDEX_FIELD_KEY, false) ? UKNOWN_FIELD_NAME : null;
        this.configureMetrics();
    }

    private void configureMetrics() {
        Preconditions.checkNotNull((Object)this.configuration);
        boolean enableMetrics = GraphDatabaseConfiguration.isMetricsEnabledInGraphConfig(this.configuration);
        if (enableMetrics) {
            Configuration metricsConf = this.configuration.subset(METRICS_NAMESPACE);
            this.metricsPrefix = metricsConf.getString("prefix", METRICS_PREFIX_DEFAULT);
            Preconditions.checkNotNull((Object)this.metricsPrefix);
            this.configureMetricsConsoleReporter(metricsConf);
            this.configureMetricsCsvReporter(metricsConf);
            this.configureMetricsJmxReporter(metricsConf);
            this.configureMetricsSlf4jReporter(metricsConf);
            this.configureMetricsGangliaReporter(metricsConf);
            this.configureMetricsGraphiteReporter(metricsConf);
        } else {
            this.metricsPrefix = null;
        }
    }

    private static boolean isMetricsEnabledInGraphConfig(Configuration graphConf) {
        Preconditions.checkNotNull((Object)graphConf);
        Configuration metricsConf = graphConf.subset(METRICS_NAMESPACE);
        Configuration storageConf = graphConf.subset(STORAGE_NAMESPACE);
        return GraphDatabaseConfiguration.isMetricsEnabled(storageConf, metricsConf);
    }

    public static boolean isMetricsEnabled(Configuration storageConf, Configuration metricsConf) {
        Preconditions.checkNotNull((Object)metricsConf);
        Preconditions.checkNotNull((Object)storageConf);
        return metricsConf.getBoolean(METRICS_ENABLED, false) || metricsConf.getBoolean(BASIC_METRICS, false) || storageConf.getBoolean(BASIC_METRICS, false);
    }

    public static boolean isMetricsMergingEnabled(Configuration storageConf, Configuration metricsConf) {
        Preconditions.checkNotNull((Object)metricsConf);
        Preconditions.checkNotNull((Object)storageConf);
        return metricsConf.getBoolean(MERGE_BASIC_METRICS_KEY, true) && storageConf.getBoolean(MERGE_BASIC_METRICS_KEY, true);
    }

    private void configureMetricsConsoleReporter(Configuration conf) {
        Long ms = conf.getLong(METRICS_CONSOLE_INTERVAL_KEY, METRICS_CONSOLE_INTERVAL_DEFAULT);
        if (null != ms) {
            log.debug("Console metrics on");
            MetricManager.INSTANCE.addConsoleReporter(ms);
        } else {
            log.debug("Console metrics off");
        }
    }

    private void configureMetricsCsvReporter(Configuration conf) {
        Long ms = conf.getLong(METRICS_CSV_INTERVAL_KEY, METRICS_CONSOLE_INTERVAL_DEFAULT);
        String out = conf.getString(METRICS_CSV_DIR_KEY, METRICS_CSV_DIR_DEFAULT);
        if (null != ms && null != out) {
            MetricManager.INSTANCE.addCsvReporter(ms, out);
        }
    }

    private void configureMetricsJmxReporter(Configuration conf) {
        boolean enabled = conf.getBoolean(METRICS_JMX_ENABLED_KEY, false);
        String domain = conf.getString(METRICS_JMX_DOMAIN_KEY, METRICS_JMX_DOMAIN_DEFAULT);
        String agentId = conf.getString(METRICS_JMX_AGENTID_KEY, METRICS_JMX_AGENTID_DEFAULT);
        if (enabled) {
            MetricManager.INSTANCE.addJmxReporter(domain, agentId);
        }
    }

    private void configureMetricsSlf4jReporter(Configuration conf) {
        Long ms = conf.getLong(METRICS_SLF4J_INTERVAL_KEY, METRICS_SLF4J_INTERVAL_DEFAULT);
        String loggerName = conf.getString(METRICS_SLF4J_LOGGER_KEY, METRICS_SLF4J_LOGGER_DEFAULT);
        if (null != ms) {
            MetricManager.INSTANCE.addSlf4jReporter(ms, loggerName);
        }
    }

    private void configureMetricsGangliaReporter(Configuration conf) {
        GMetric.UDPAddressingMode addrMode;
        Configuration ganglia = conf.subset(GANGLIA_NAMESPACE);
        if (null == ganglia) {
            return;
        }
        String host = ganglia.getString("hostname", null);
        Long ms = ganglia.getLong("interval", null);
        if (null == host || null == ms) {
            return;
        }
        Integer port = ganglia.getInt("port", 8649);
        String addrModeStr = ganglia.getString(GANGLIA_ADDRESSING_MODE_KEY, GANGLIA_ADDRESSING_MODE_DEFAULT);
        if (addrModeStr.toLowerCase().equals("multicast")) {
            addrMode = GMetric.UDPAddressingMode.MULTICAST;
        } else if (addrModeStr.toLowerCase().equals(GANGLIA_ADDRESSING_MODE_DEFAULT)) {
            addrMode = GMetric.UDPAddressingMode.UNICAST;
        } else {
            throw new RuntimeException("Invalid setting metrics.ganglia.addressing-mode=\"" + addrModeStr + "\": must be \"unicast\" or \"multicast\"");
        }
        Boolean proto31 = ganglia.getBoolean(GANGLIA_USE_PROTOCOL_31_KEY, true);
        int ttl = ganglia.getInt(GANGLIA_TTL_KEY, 1);
        String uuidStr = ganglia.getString(GANGLIA_UUID_KEY);
        UUID uuid = null != uuidStr ? UUID.fromString(uuidStr) : GANGLIA_UUID_DEFAULT;
        String spoof = ganglia.getString(GANGLIA_SPOOF_KEY, GANGLIA_SPOOF_DEFAULT);
        if (null != spoof && 0 > spoof.indexOf(58)) {
            throw new RuntimeException("Invalid setting metrics.ganglia.spoof=\"" + spoof + "\": must be formatted as \"IP:hostname\"");
        }
        try {
            MetricManager.INSTANCE.addGangliaReporter(host, port, addrMode, ttl, proto31, uuid, spoof, ms);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void configureMetricsGraphiteReporter(Configuration conf) {
        Configuration graphite = conf.subset(GRAPHITE_NAMESPACE);
        if (null == graphite) {
            return;
        }
        String host = graphite.getString("hostname", null);
        Long ms = graphite.getLong("interval", null);
        if (null == host || null == ms) {
            return;
        }
        Integer port = graphite.getInt("port", 2003);
        String prefix = graphite.getString("prefix", GRAPHITE_PREFIX_DEFAULT);
        MetricManager.INSTANCE.addGraphiteReporter(host, port, prefix, ms);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean hasFlushIDs() {
        return this.flushIDs;
    }

    public int getTxCacheSize() {
        return this.txCacheSize;
    }

    public boolean isBatchLoading() {
        return this.batchLoading;
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    public DefaultTypeMaker getDefaultTypeMaker() {
        return this.defaultTypeMaker;
    }

    public boolean allowVertexIdSetting() {
        return this.allowVertexIdSetting;
    }

    public boolean hasPropertyPrefetching() {
        if (this.propertyPrefetching == null) {
            return this.getStoreFeatures().isDistributed();
        }
        return this.propertyPrefetching;
    }

    public String getUnknownIndexKeydName() {
        return this.unknownIndexKeydName;
    }

    public int getWriteAttempts() {
        int attempts = this.configuration.subset(STORAGE_NAMESPACE).getInt(WRITE_ATTEMPTS_KEY, 5);
        Preconditions.checkArgument((attempts > 0 ? 1 : 0) != 0, (Object)"Write attempts must be positive");
        return attempts;
    }

    public int getReadAttempts() {
        int attempts = this.configuration.subset(STORAGE_NAMESPACE).getInt(READ_ATTEMPTS_KEY, 3);
        Preconditions.checkArgument((attempts > 0 ? 1 : 0) != 0, (Object)"Read attempts must be positive");
        return attempts;
    }

    public int getStorageWaittime() {
        int time = this.configuration.subset(STORAGE_NAMESPACE).getInt(STORAGE_ATTEMPT_WAITTIME_KEY, 250);
        Preconditions.checkArgument((time > 0 ? 1 : 0) != 0, (Object)"Persistence attempt retry wait time must be positive");
        return time;
    }

    public static List<RegisteredAttributeClass<?>> getRegisteredAttributeClasses(Configuration config) {
        ArrayList all = new ArrayList();
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(ATTRIBUTE_PREFIX)) continue;
            try {
                int position = Integer.parseInt(key.substring(ATTRIBUTE_PREFIX.length()));
                Class<?> clazz = null;
                AttributeHandler serializer = null;
                String classname = config.getString(key);
                try {
                    clazz = Class.forName(classname);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not find attribute class" + classname, e);
                }
                Preconditions.checkNotNull(clazz);
                if (config.containsKey(SERIALIZER_PREFIX + position)) {
                    String serializername = config.getString(SERIALIZER_PREFIX + position);
                    try {
                        Class<?> sclass = Class.forName(serializername);
                        serializer = (AttributeHandler)sclass.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Could not find serializer class" + serializername);
                    }
                    catch (InstantiationException e) {
                        throw new IllegalArgumentException("Could not instantiate serializer class" + serializername, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException("Could not instantiate serializer class" + serializername, e);
                    }
                }
                RegisteredAttributeClass reg = new RegisteredAttributeClass(clazz, serializer, position);
                for (int i = 0; i < all.size(); ++i) {
                    if (!((RegisteredAttributeClass)all.get(i)).equals(reg)) continue;
                    throw new IllegalArgumentException("Duplicate attribute registration: " + all.get(i) + " and " + reg);
                }
                all.add(reg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid attribute definition: " + key, e);
            }
        }
        Collections.sort(all);
        return all;
    }

    public VertexIDAssigner getIDAssigner(Backend backend) {
        return new VertexIDAssigner(this.configuration.subset(IDS_NAMESPACE), backend.getIDAuthority(), backend.getStoreFeatures());
    }

    public String getBackendDescription() {
        Configuration storageconfig = this.configuration.subset(STORAGE_NAMESPACE);
        String clazzname = storageconfig.getString("backend", STORAGE_BACKEND_DEFAULT);
        if (storageconfig.containsKey("hostname")) {
            return clazzname + ":" + storageconfig.getString("hostname");
        }
        return clazzname + ":" + storageconfig.getString(STORAGE_DIRECTORY_KEY);
    }

    public Backend getBackend() {
        Configuration storageconfig = this.configuration.subset(STORAGE_NAMESPACE);
        Configuration metricsconfig = this.configuration.subset(METRICS_NAMESPACE);
        Backend backend = new Backend(storageconfig, metricsconfig);
        backend.initialize(storageconfig);
        this.storeFeatures = backend.getStoreFeatures();
        return backend;
    }

    public StoreFeatures getStoreFeatures() {
        Preconditions.checkArgument((this.storeFeatures != null ? 1 : 0) != 0, (Object)"Cannot retrieve store features before the storage backend has been initialized");
        return this.storeFeatures;
    }

    public StoreCache getEdgeStoreCache() {
        long cacheSizeBytes;
        double cachesize;
        Configuration cacheconf = this.configuration.subset(CACHE_NAMESPACE);
        if (this.batchLoading || !cacheconf.getBoolean(DB_CACHE_KEY, false)) {
            return new PassThroughStoreCache();
        }
        long expirationTime = cacheconf.getLong(DB_CACHE_TIME_KEY, 10000L);
        Preconditions.checkArgument((expirationTime >= 0L ? 1 : 0) != 0, (String)"Invalid cache expiration time: %s", (Object[])new Object[]{expirationTime});
        if (expirationTime == 0L) {
            expirationTime = 6307200000000L;
        }
        Preconditions.checkArgument(((cachesize = cacheconf.getDouble(DB_CACHE_SIZE_KEY, 0.3)) > 0.0 ? 1 : 0) != 0, (String)"Invalid cache size specified: %s", (Object[])new Object[]{cachesize});
        if (cachesize < 1.0) {
            Runtime runtime = Runtime.getRuntime();
            cacheSizeBytes = (long)((double)(runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) * cachesize);
        } else {
            Preconditions.checkArgument((cachesize > 1000.0 ? 1 : 0) != 0, (String)"Cache size is too small: %s", (Object[])new Object[]{cachesize});
            cacheSizeBytes = (long)cachesize;
        }
        log.info("Configuring edge store cache size: {}", (Object)cacheSizeBytes);
        return new ExpirationStoreCache(expirationTime, cacheconf.getLong(DB_CACHE_CLEAN_WAIT_KEY, 50L), cacheSizeBytes);
    }

    public Serializer getSerializer() {
        Configuration config = this.configuration.subset(ATTRIBUTE_NAMESPACE);
        KryoSerializer serializer = new KryoSerializer(config.getBoolean(ATTRIBUTE_ALLOW_ALL_SERIALIZABLE_KEY, true));
        for (RegisteredAttributeClass<?> clazz : GraphDatabaseConfiguration.getRegisteredAttributeClasses(config)) {
            clazz.registerWith(serializer);
        }
        return serializer;
    }

    public boolean hasSerializeAll() {
        return this.configuration.subset(ATTRIBUTE_NAMESPACE).getBoolean(ATTRIBUTE_ALLOW_ALL_SERIALIZABLE_KEY, true);
    }

    public static final String keyInNamespace(String namespace, String key) {
        return namespace + "." + key;
    }

    public File getHomeDirectory() {
        if (!this.configuration.containsKey(GraphDatabaseConfiguration.keyInNamespace(STORAGE_NAMESPACE, STORAGE_DIRECTORY_KEY))) {
            throw new UnsupportedOperationException("No home directory specified");
        }
        File dir = new File(this.configuration.getString(GraphDatabaseConfiguration.keyInNamespace(STORAGE_NAMESPACE, STORAGE_DIRECTORY_KEY)));
        Preconditions.checkArgument((boolean)dir.isDirectory(), (Object)"Not a directory");
        return dir;
    }

    public String getHomePath() {
        return GraphDatabaseConfiguration.getPath(this.getHomeDirectory());
    }

    private static File getSubDirectory(String base, String sub) {
        File subdir = new File(base, sub);
        if (!subdir.exists() && !subdir.mkdir()) {
            throw new IllegalArgumentException("Cannot create subdirectory: " + sub);
        }
        assert (subdir.exists() && subdir.isDirectory());
        return subdir;
    }

    private static String getFileName(String dir, String file) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir + file;
    }

    public static String getPath(File dir) {
        return dir.getAbsolutePath() + File.separator;
    }

    static boolean existsFile(String file) {
        return new File(file).isFile();
    }

    static PropertiesConfiguration getPropertiesConfig(String file) {
        PropertiesConfiguration config = new PropertiesConfiguration();
        if (GraphDatabaseConfiguration.existsFile(file)) {
            try {
                config.load(file);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException("Cannot load existing configuration file", e);
            }
        }
        config.setFileName(file);
        config.setAutoSave(true);
        return config;
    }

    public static Set<String> getUnqiuePrefixes(Configuration config) {
        HashSet<String> names = new HashSet<String>();
        Iterator keyiter = config.getKeys();
        while (keyiter.hasNext()) {
            String key = (String)keyiter.next();
            int pos = key.indexOf(46);
            if (pos <= 0) continue;
            names.add(key.substring(0, pos));
        }
        return names;
    }
}

