/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.blueprints;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.KeyMaker;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.types.TitanTypeClass;
import com.thinkaurelius.titan.graphdb.types.system.SystemKey;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanBlueprintsTransaction
implements TitanTransaction {
    private static final Logger log = LoggerFactory.getLogger(TitanBlueprintsTransaction.class);

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        switch (conclusion) {
            case SUCCESS: {
                this.commit();
                break;
            }
            case FAILURE: {
                this.rollback();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized conclusion: " + conclusion);
            }
        }
    }

    public Features getFeatures() {
        throw new UnsupportedOperationException("Not supported threaded transaction graph. Call on parent graph");
    }

    public TitanVertex addVertex(Object id) {
        if (id instanceof Number && AttributeUtil.isWholeNumber((Number)id)) {
            return this.addVertex(((Number)id).longValue());
        }
        return this.addVertex(null);
    }

    public TitanVertex getVertex(Object id) {
        long longId;
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof Vertex) {
            return this.getVertex(((Vertex)id).getId());
        }
        if (id instanceof Long) {
            longId = (Long)id;
        } else if (id instanceof Number) {
            longId = ((Number)id).longValue();
        } else {
            try {
                longId = Long.valueOf(id.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return this.getVertex(longId);
    }

    public Iterable<Vertex> getVertices(String key, Object attribute) {
        if (!this.containsType(key)) {
            return IterablesUtil.emptyIterable();
        }
        return this.getVertices(this.getPropertyKey(key), attribute);
    }

    public void removeVertex(Vertex vertex) {
        vertex.remove();
    }

    public TitanEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Preconditions.checkArgument((boolean)(outVertex instanceof TitanVertex));
        Preconditions.checkArgument((boolean)(inVertex instanceof TitanVertex));
        return this.addEdge((TitanVertex)outVertex, (TitanVertex)inVertex, label);
    }

    @Override
    public TitanEdge addEdge(TitanVertex outVertex, TitanVertex inVertex, String label) {
        if (null == label) {
            throw new IllegalArgumentException("Edge label must be non-null");
        }
        return this.addEdge(outVertex, inVertex, this.getEdgeLabel(label));
    }

    public TitanEdge getEdge(Object id) {
        if (id == null) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        RelationIdentifier rid = null;
        try {
            if (id instanceof TitanEdge) {
                rid = (RelationIdentifier)((TitanEdge)id).getId();
            } else if (id instanceof RelationIdentifier) {
                rid = (RelationIdentifier)id;
            } else if (id instanceof String) {
                rid = RelationIdentifier.parse((String)id);
            } else if (id instanceof long[]) {
                rid = RelationIdentifier.get((long[])id);
            } else if (id instanceof int[]) {
                rid = RelationIdentifier.get((int[])id);
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (rid != null) {
            return rid.findEdge(this);
        }
        return null;
    }

    public void removeEdge(Edge edge) {
        edge.remove();
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        if (!this.containsType(key)) {
            return IterablesUtil.emptyIterable();
        }
        return this.getEdges(this.getPropertyKey(key), value);
    }

    @Override
    public TitanProperty addProperty(TitanVertex vertex, String key, Object attribute) {
        return this.addProperty(vertex, this.getPropertyKey(key), attribute);
    }

    public void shutdown() {
        this.commit();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, null);
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        throw new UnsupportedOperationException("Key indexes cannot currently be dropped. Create a new key instead.");
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, com.tinkerpop.blueprints.Parameter ... indexParameters) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((elementClass == Element.class || elementClass == Vertex.class || elementClass == Edge.class ? 1 : 0) != 0, (Object)"Expected vertex, edge or element");
        if (indexParameters == null || indexParameters.length == 0) {
            indexParameters = new com.tinkerpop.blueprints.Parameter[]{new com.tinkerpop.blueprints.Parameter((Object)"standard", (Object)"")};
        }
        if (this.containsType(key)) {
            TitanType type = this.getType(key);
            if (!type.isPropertyKey()) {
                throw new IllegalArgumentException("Key string does not denote a property key but a label");
            }
            ArrayList<String> indexes = new ArrayList<String>(indexParameters.length);
            for (com.tinkerpop.blueprints.Parameter p : indexParameters) {
                Preconditions.checkArgument((boolean)(p.getKey() instanceof String), (Object)("Invalid index argument: " + p));
                indexes.add((String)p.getKey());
            }
            boolean indexesCovered = elementClass == Element.class ? TitanBlueprintsTransaction.hasIndexes((TitanKey)type, Vertex.class, indexes) && TitanBlueprintsTransaction.hasIndexes((TitanKey)type, Edge.class, indexes) : TitanBlueprintsTransaction.hasIndexes((TitanKey)type, elementClass, indexes);
            if (!indexesCovered) {
                throw new UnsupportedOperationException("Cannot add an index to an already existing property key: " + type.getName());
            }
        } else {
            KeyMaker tm = this.makeKey(key).dataType(Object.class);
            for (com.tinkerpop.blueprints.Parameter p : indexParameters) {
                Preconditions.checkArgument((boolean)(p.getKey() instanceof String), (Object)("Invalid index argument: " + p));
                tm.indexed((String)p.getKey(), elementClass, new Parameter[0]);
            }
            tm.make();
        }
    }

    private static final boolean hasIndexes(TitanKey key, Class<? extends Element> elementClass, List<String> indexes) {
        for (String index : indexes) {
            if (Iterables.contains(key.getIndexes(elementClass), (Object)index)) continue;
            return false;
        }
        return true;
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        Preconditions.checkArgument((elementClass == Vertex.class || elementClass == Edge.class ? 1 : 0) != 0, (Object)"Must provide either Vertex.class or Edge.class as an argument");
        HashSet<String> indexedkeys = new HashSet<String>();
        for (TitanKey k : this.getTypes(TitanKey.class)) {
            if (Iterables.isEmpty(k.getIndexes(elementClass))) continue;
            indexedkeys.add(k.getName());
        }
        return indexedkeys;
    }

    @Override
    public <T extends TitanType> Iterable<T> getTypes(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        Iterable types = null;
        if (TitanKey.class.equals(clazz)) {
            types = this.getVertices(SystemKey.TypeClass, (Object)TitanTypeClass.KEY);
        } else if (TitanLabel.class.equals(clazz)) {
            types = this.getVertices(SystemKey.TypeClass, (Object)TitanTypeClass.LABEL);
        } else if (TitanType.class.equals(clazz)) {
            types = Iterables.concat(this.getVertices(SystemKey.TypeClass, (Object)TitanTypeClass.KEY), this.getVertices(SystemKey.TypeClass, (Object)TitanTypeClass.LABEL));
        } else {
            throw new IllegalArgumentException("Unknown type class: " + clazz);
        }
        return Iterables.filter(types, clazz);
    }
}

