/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.example;

import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.io.File;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class GraphOfTheGodsFactory {
    public static final String INDEX_NAME = "search";

    public static TitanGraph create(String directory) {
        BaseConfiguration config = new BaseConfiguration();
        Configuration storage = config.subset("storage");
        storage.setProperty("backend", (Object)"local");
        storage.setProperty("directory", (Object)directory);
        Configuration index = storage.subset("index").subset(INDEX_NAME);
        index.setProperty("backend", (Object)"elasticsearch");
        index.setProperty("local-mode", (Object)true);
        index.setProperty("client-only", (Object)false);
        index.setProperty("directory", (Object)(directory + File.separator + "es"));
        TitanGraph graph = TitanFactory.open((Configuration)config);
        GraphOfTheGodsFactory.load(graph);
        return graph;
    }

    public static void load(TitanGraph graph) {
        graph.makeKey("name").dataType(String.class).indexed(Vertex.class).unique().make();
        graph.makeKey("age").dataType(Integer.class).indexed(INDEX_NAME, Vertex.class, new Parameter[0]).make();
        graph.makeKey("type").dataType(String.class).make();
        TitanKey time = graph.makeKey("time").dataType(Integer.class).make();
        TitanKey reason = graph.makeKey("reason").dataType(String.class).indexed(INDEX_NAME, Edge.class, new Parameter[0]).make();
        graph.makeKey("place").dataType(Geoshape.class).indexed(INDEX_NAME, Edge.class, new Parameter[0]).make();
        graph.makeLabel("father").manyToOne().make();
        graph.makeLabel("mother").manyToOne().make();
        graph.makeLabel("battled").sortKey(time).make();
        graph.makeLabel("lives").signature(reason).make();
        graph.makeLabel("pet").make();
        graph.makeLabel("brother").make();
        graph.commit();
        Vertex saturn = graph.addVertex(null);
        saturn.setProperty("name", (Object)"saturn");
        saturn.setProperty("age", (Object)10000);
        saturn.setProperty("type", (Object)"titan");
        Vertex sky = graph.addVertex(null);
        ElementHelper.setProperties((Element)sky, (Object[])new Object[]{"name", "sky", "type", "location"});
        Vertex sea = graph.addVertex(null);
        ElementHelper.setProperties((Element)sea, (Object[])new Object[]{"name", "sea", "type", "location"});
        Vertex jupiter = graph.addVertex(null);
        ElementHelper.setProperties((Element)jupiter, (Object[])new Object[]{"name", "jupiter", "age", 5000, "type", "god"});
        Vertex neptune = graph.addVertex(null);
        ElementHelper.setProperties((Element)neptune, (Object[])new Object[]{"name", "neptune", "age", 4500, "type", "god"});
        Vertex hercules = graph.addVertex(null);
        ElementHelper.setProperties((Element)hercules, (Object[])new Object[]{"name", "hercules", "age", 30, "type", "demigod"});
        Vertex alcmene = graph.addVertex(null);
        ElementHelper.setProperties((Element)alcmene, (Object[])new Object[]{"name", "alcmene", "age", 45, "type", "human"});
        Vertex pluto = graph.addVertex(null);
        ElementHelper.setProperties((Element)pluto, (Object[])new Object[]{"name", "pluto", "age", 4000, "type", "god"});
        Vertex nemean = graph.addVertex(null);
        ElementHelper.setProperties((Element)nemean, (Object[])new Object[]{"name", "nemean", "type", "monster"});
        Vertex hydra = graph.addVertex(null);
        ElementHelper.setProperties((Element)hydra, (Object[])new Object[]{"name", "hydra", "type", "monster"});
        Vertex cerberus = graph.addVertex(null);
        ElementHelper.setProperties((Element)cerberus, (Object[])new Object[]{"name", "cerberus", "type", "monster"});
        Vertex tartarus = graph.addVertex(null);
        ElementHelper.setProperties((Element)tartarus, (Object[])new Object[]{"name", "tartarus", "type", "location"});
        jupiter.addEdge("father", saturn);
        jupiter.addEdge("lives", sky).setProperty("reason", (Object)"loves fresh breezes");
        jupiter.addEdge("brother", neptune);
        jupiter.addEdge("brother", pluto);
        neptune.addEdge("lives", sea).setProperty("reason", (Object)"loves waves");
        neptune.addEdge("brother", jupiter);
        neptune.addEdge("brother", pluto);
        hercules.addEdge("father", jupiter);
        hercules.addEdge("mother", alcmene);
        ElementHelper.setProperties((Element)hercules.addEdge("battled", nemean), (Object[])new Object[]{"time", 1, "place", Geoshape.point(38.1f, 23.7f)});
        ElementHelper.setProperties((Element)hercules.addEdge("battled", hydra), (Object[])new Object[]{"time", 2, "place", Geoshape.point(37.7f, 23.9f)});
        ElementHelper.setProperties((Element)hercules.addEdge("battled", cerberus), (Object[])new Object[]{"time", 12, "place", Geoshape.point(39.0f, 22.0f)});
        pluto.addEdge("brother", jupiter);
        pluto.addEdge("brother", neptune);
        pluto.addEdge("lives", tartarus).setProperty("reason", (Object)"no fear of death");
        pluto.addEdge("pet", cerberus);
        cerberus.addEdge("lives", tartarus);
        graph.commit();
    }
}

