/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.util.TimestampProvider;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtility
extends Enum<TimeUtility>
implements TimestampProvider {
    public static final /* enum */ TimeUtility INSTANCE = new TimeUtility();
    private static final Logger log;
    private final long t0NanoTime;
    private final long t0NanosSinceEpoch;
    private static final long MILLION = 1000000L;
    private static final /* synthetic */ TimeUtility[] $VALUES;

    public static TimeUtility[] values() {
        return (TimeUtility[])$VALUES.clone();
    }

    public static TimeUtility valueOf(String name) {
        return Enum.valueOf(TimeUtility.class, name);
    }

    private TimeUtility() {
        long t0ms = System.currentTimeMillis();
        long t0ns = System.nanoTime();
        this.t0NanosSinceEpoch = t0ms * 1000L * 1000L;
        this.t0NanoTime = t0ns;
    }

    @Override
    public long getApproxNSSinceEpoch() {
        return System.nanoTime() - this.t0NanoTime + this.t0NanosSinceEpoch;
    }

    @Override
    public long sleepUntil(long untilNS) throws InterruptedException {
        long nowNS = this.getApproxNSSinceEpoch();
        while (nowNS < untilNS) {
            long deltaNS = untilNS - nowNS;
            long deltaMS = 0L != deltaNS % 1000000L ? deltaNS / 1000000L + 1L : deltaNS / 1000000L;
            if (0L >= deltaMS) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipped sleep: target wakeup time {} ms already past current time {} ms (delta {})", new Object[]{TimeUnit.MILLISECONDS.convert(untilNS, TimeUnit.NANOSECONDS), TimeUnit.MILLISECONDS.convert(nowNS, TimeUnit.NANOSECONDS), deltaMS});
                }
                return nowNS;
            }
            if (log.isDebugEnabled()) {
                log.debug("Sleeping: target wakeup time {} ms, current time {} ms, duration {} ms", new Object[]{TimeUnit.MILLISECONDS.convert(untilNS, TimeUnit.NANOSECONDS), TimeUnit.MILLISECONDS.convert(nowNS, TimeUnit.NANOSECONDS), deltaMS});
            }
            Thread.sleep(deltaMS);
            nowNS = this.getApproxNSSinceEpoch();
        }
        return nowNS;
    }

    public final void sleepUntil(long untilTimeMillis, Logger log) throws StorageException {
        long now;
        while ((now = System.currentTimeMillis()) <= untilTimeMillis) {
            long delta = untilTimeMillis - now + 1L;
            assert (0L <= delta);
            try {
                if (log != null) {
                    log.debug("About to sleep for {} ms", (Object)delta);
                }
                Thread.sleep(delta);
            }
            catch (InterruptedException e) {
                throw new PermanentLockingException("Interrupted while waiting", e);
            }
        }
    }

    static {
        $VALUES = new TimeUtility[]{INSTANCE};
        log = LoggerFactory.getLogger(TimeUtility.class);
    }
}

