/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ConsistencyLevel;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedValueCheckingTransaction
implements StoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(ExpectedValueCheckingTransaction.class);
    private boolean isMutationStarted;
    private final StoreTransaction baseTx;
    private final StoreTransaction consistentTx;
    private final int retryCount;
    private final Map<ExpectedValueCheckingStore, Map<KeyColumn, StaticBuffer>> expectedValuesByStore = new HashMap<ExpectedValueCheckingStore, Map<KeyColumn, StaticBuffer>>();

    public ExpectedValueCheckingTransaction(StoreTransaction baseTx, StoreTransaction consistentTx, int retryCount) {
        Preconditions.checkArgument((consistentTx.getConfiguration().getConsistency() == ConsistencyLevel.KEY_CONSISTENT ? 1 : 0) != 0);
        this.baseTx = baseTx;
        this.consistentTx = consistentTx;
        this.retryCount = retryCount;
    }

    StoreTransaction getBaseTransaction() {
        return this.baseTx;
    }

    StoreTransaction getConsistentTransaction() {
        return this.consistentTx;
    }

    private void lockedOn(ExpectedValueCheckingStore store) {
        Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
        if (null == m) {
            m = new HashMap<KeyColumn, StaticBuffer>();
            this.expectedValuesByStore.put(store, m);
        }
    }

    void storeExpectedValue(ExpectedValueCheckingStore store, KeyColumn lockID, StaticBuffer value) {
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)lockID);
        this.lockedOn(store);
        Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
        assert (null != m);
        if (m.containsKey(lockID)) {
            log.debug("Multiple expected values for {}: keeping initial value {} and discarding later value {}", new Object[]{lockID, m.get(lockID), value});
        } else {
            m.put(lockID, value);
            log.debug("Store expected value for {}: {}", (Object)lockID, (Object)value);
        }
    }

    void checkExpectedValues() throws StorageException {
        for (ExpectedValueCheckingStore store : this.expectedValuesByStore.keySet()) {
            Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
            for (KeyColumn kc : m.keySet()) {
                this.checkSingleExpectedValue(kc, m.get(kc), store);
            }
        }
    }

    private void checkSingleExpectedValue(KeyColumn kc, StaticBuffer ev, ExpectedValueCheckingStore store) throws StorageException {
        for (int i = 0; i < this.retryCount; ++i) {
            int retriesLeft = this.retryCount - 1 - i;
            try {
                this.checkSingleExpectedValueUnsafe(kc, ev, store);
                return;
            }
            catch (TemporaryStorageException e) {
                log.warn("Failed to check expected value (" + retriesLeft + " retries remaining)", (Throwable)e);
                continue;
            }
            catch (PermanentStorageException e) {
                log.error("Failed to check expected value (exception is permanent; won't retry)", (Throwable)e);
                throw e;
            }
        }
        throw new TemporaryStorageException("Lock write retry count exceeded");
    }

    private void checkSingleExpectedValueUnsafe(final KeyColumn kc, StaticBuffer ev, ExpectedValueCheckingStore store) throws StorageException {
        Iterable avList;
        ImmutableList evList;
        KeySliceQuery ksq = new KeySliceQuery(kc.getKey(), kc.getColumn(), ByteBufferUtil.nextBiggerBuffer(kc.getColumn()));
        ImmutableList actualEntries = store.getSlice(ksq, this);
        if (null == actualEntries) {
            actualEntries = ImmutableList.of();
        }
        if (!Iterables.elementsEqual((Iterable)(evList = null == ev ? ImmutableList.of() : ImmutableList.of((Object)ev)), (Iterable)(avList = Iterables.transform((Iterable)actualEntries, (Function)new Function<Entry, StaticBuffer>(){

            public StaticBuffer apply(Entry e) {
                assert (null != e.getColumn());
                assert (e.getColumn().equals(kc.getColumn()));
                return e.getValue();
            }
        })))) {
            throw new PermanentLockingException("Expected value mismatch for " + kc + ": expected=" + evList + " vs actual=" + avList + " (store=" + store.getName() + ")");
        }
    }

    private void deleteAllLocks() throws StorageException {
        for (ExpectedValueCheckingStore s : this.expectedValuesByStore.keySet()) {
            s.deleteLocks(this);
        }
    }

    @Override
    public void rollback() throws StorageException {
        this.deleteAllLocks();
        this.baseTx.rollback();
        this.consistentTx.rollback();
    }

    @Override
    public void commit() throws StorageException {
        this.baseTx.commit();
        this.deleteAllLocks();
        this.consistentTx.commit();
    }

    @Override
    public void flush() throws StorageException {
        this.baseTx.flush();
        this.consistentTx.flush();
    }

    public boolean isMutationStarted() {
        return this.isMutationStarted;
    }

    public void mutationStarted() {
        this.isMutationStarted = true;
    }

    @Override
    public StoreTxConfig getConfiguration() {
        return this.baseTx.getConfiguration();
    }
}

