/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeySelector;

public class LimitedSelector
implements KeySelector {
    private final int limit;
    private int count;

    public LimitedSelector(int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)("The count limit needs to be positive. Given: " + limit));
        this.limit = limit;
        this.count = 0;
    }

    public static final LimitedSelector of(int limit) {
        return new LimitedSelector(limit);
    }

    @Override
    public boolean include(StaticBuffer key) {
        ++this.count;
        return true;
    }

    @Override
    public boolean reachedLimit() {
        return this.count >= this.limit;
    }
}

