/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory.InMemoryKeyColumnValueStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class InMemoryStoreManager
implements KeyColumnValueStoreManager {
    private final ConcurrentHashMap<String, InMemoryKeyColumnValueStore> stores = new ConcurrentHashMap();
    private final StoreFeatures features;
    private final Map<String, String> storeConfig = new ConcurrentHashMap<String, String>();

    public InMemoryStoreManager() {
        this((Configuration)new BaseConfiguration());
    }

    public InMemoryStoreManager(Configuration configuration) {
        this.features = new StoreFeatures();
        this.features.supportsOrderedScan = true;
        this.features.supportsUnorderedScan = true;
        this.features.supportsBatchMutation = false;
        this.features.supportsTransactions = false;
        this.features.supportsConsistentKeyOperations = true;
        this.features.supportsLocking = false;
        this.features.isDistributed = false;
        this.features.supportsMultiQuery = false;
        this.features.isKeyOrdered = true;
        this.features.hasLocalKeyPartition = false;
    }

    @Override
    public StoreTransaction beginTransaction(StoreTxConfig config) throws StorageException {
        return new TransactionHandle(config);
    }

    @Override
    public void close() throws StorageException {
        for (InMemoryKeyColumnValueStore store : this.stores.values()) {
            store.close();
        }
        this.stores.clear();
    }

    @Override
    public void clearStorage() throws StorageException {
        for (InMemoryKeyColumnValueStore store : this.stores.values()) {
            store.clear();
        }
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.features;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name) throws StorageException {
        if (!this.stores.containsKey(name)) {
            this.stores.putIfAbsent(name, new InMemoryKeyColumnValueStore(name));
        }
        KeyColumnValueStore store = this.stores.get(name);
        Preconditions.checkNotNull((Object)store);
        return store;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> storeMut : mutations.entrySet()) {
            KeyColumnValueStore store = this.stores.get(storeMut.getKey());
            Preconditions.checkNotNull((Object)store);
            for (Map.Entry<StaticBuffer, KCVMutation> keyMut : storeMut.getValue().entrySet()) {
                store.mutate(keyMut.getKey(), keyMut.getValue().getAdditions(), keyMut.getValue().getDeletions(), txh);
            }
        }
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private class TransactionHandle
    extends AbstractStoreTransaction {
        public TransactionHandle(StoreTxConfig config) {
            super(config);
        }
    }
}

