/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import java.nio.ByteBuffer;

public class StaticBufferEntry
implements Entry {
    public static final StaticBuffer NO_VALUE = null;
    private final StaticBuffer column;
    private final StaticBuffer value;
    private volatile transient RelationCache cache;

    public StaticBufferEntry(StaticBuffer column, StaticBuffer value) {
        Preconditions.checkNotNull((Object)column);
        this.column = column;
        this.value = value;
    }

    public static Entry of(StaticBuffer column) {
        return new StaticBufferEntry(column, NO_VALUE);
    }

    public static Entry of(StaticBuffer column, StaticBuffer value) {
        return new StaticBufferEntry(column, value);
    }

    @Override
    public int getByteSize() {
        return 144 + 2 * (this.column.length() + this.value.length());
    }

    @Override
    public StaticBuffer getColumn() {
        return this.column;
    }

    @Override
    public StaticBuffer getValue() {
        return this.value;
    }

    @Override
    public ReadBuffer getReadColumn() {
        return this.column.asReadBuffer();
    }

    @Override
    public ReadBuffer getReadValue() {
        return this.value.asReadBuffer();
    }

    @Override
    public byte[] getArrayColumn() {
        return this.column.as(StaticBuffer.ARRAY_FACTORY);
    }

    @Override
    public byte[] getArrayValue() {
        return this.value.as(StaticBuffer.ARRAY_FACTORY);
    }

    @Override
    public ByteBuffer getByteBufferColumn() {
        return this.column.asByteBuffer();
    }

    @Override
    public ByteBuffer getByteBufferValue() {
        return this.value.asByteBuffer();
    }

    public int hashCode() {
        return this.getColumn().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)obj;
        return this.getColumn().equals(other.getColumn());
    }

    public String toString() {
        return this.column.toString() + "->" + this.value.toString();
    }

    @Override
    public int compareTo(Entry entry) {
        return this.column.compareTo(entry.getColumn());
    }

    @Override
    public RelationCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(RelationCache cache) {
        Preconditions.checkNotNull((Object)cache);
        this.cache = cache;
    }
}

