/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedKeyColumnValueStore
implements KeyColumnValueStore {
    private static final Logger log = LoggerFactory.getLogger(CachedKeyColumnValueStore.class);
    private static final String METRICS_PREFIX = "com.thinkaurelius.titan.sys." + CachedKeyColumnValueStore.class.getSimpleName();
    private static final Counter CACHE_RETRIEVAL = MetricManager.INSTANCE.getCounter(METRICS_PREFIX, "retrievals");
    private static final Counter CACHE_MISS = MetricManager.INSTANCE.getCounter(METRICS_PREFIX, "misses");
    private static final long DEFAULT_CACHE_SIZE = 2000L;
    private final KeyColumnValueStore store;
    private final Cache<KeySliceQuery, List<Entry>> cache;

    public CachedKeyColumnValueStore(KeyColumnValueStore store) {
        this(store, 2000L);
    }

    public CachedKeyColumnValueStore(KeyColumnValueStore store, long cacheSize) {
        Preconditions.checkNotNull((Object)store);
        this.store = store;
        this.cache = CacheBuilder.newBuilder().weigher((Weigher)new Weigher<KeySliceQuery, List<Entry>>(){

            public int weigh(KeySliceQuery q, List<Entry> r) {
                return 2 + r.size();
            }
        }).maximumWeight(cacheSize).build();
    }

    public static long getGlobalCacheHits() {
        return CACHE_RETRIEVAL.getCount() - CACHE_MISS.getCount();
    }

    public static long getGlobalCacheMisses() {
        return CACHE_MISS.getCount();
    }

    public static void resetGlobalMetrics() {
        CACHE_MISS.dec(CACHE_MISS.getCount());
        CACHE_RETRIEVAL.dec(CACHE_RETRIEVAL.getCount());
    }

    @Override
    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws StorageException {
        return this.store.containsKey(key, txh);
    }

    @Override
    public List<Entry> getSlice(final KeySliceQuery query, final StoreTransaction txh) throws StorageException {
        if (query.isStatic()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Cache Retrieval on " + this.store.getName() + ". Attempts: {} | Misses: {}", (Object)CACHE_RETRIEVAL.getCount(), (Object)CACHE_MISS.getCount());
                }
                CACHE_RETRIEVAL.inc();
                List result = (List)this.cache.get((Object)query, (Callable)new Callable<List<Entry>>(){

                    @Override
                    public List<Entry> call() throws StorageException {
                        CACHE_MISS.inc();
                        return CachedKeyColumnValueStore.this.store.getSlice(query, txh);
                    }
                });
                if (result.isEmpty()) {
                    this.cache.invalidate((Object)query);
                }
                return result;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof StorageException) {
                    throw (StorageException)cause;
                }
                throw new TemporaryStorageException("Exception while accessing cache", e);
            }
        }
        return this.store.getSlice(query, txh);
    }

    @Override
    public List<List<Entry>> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        if (query.isStatic() && !query.hasLimit()) {
            ArrayList<List<Entry>> results = new ArrayList<List<Entry>>(keys.size());
            for (StaticBuffer key : keys) {
                results.add(this.getSlice(new KeySliceQuery(key, query), txh));
            }
            return results;
        }
        return this.store.getSlice(keys, query, txh);
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        this.store.mutate(key, additions, deletions, txh);
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        this.store.acquireLock(key, column, expectedValue, txh);
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery keyQuery, StoreTransaction txh) throws StorageException {
        return this.store.getKeys(keyQuery, txh);
    }

    @Override
    public KeyIterator getKeys(SliceQuery columnQuery, StoreTransaction txh) throws StorageException {
        return this.store.getKeys(columnQuery, txh);
    }

    @Override
    public StaticBuffer[] getLocalKeyPartition() throws StorageException {
        return this.store.getLocalKeyPartition();
    }

    @Override
    public String getName() {
        return this.store.getName();
    }

    @Override
    public void close() throws StorageException {
        this.store.close();
    }
}

