/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.ReadByteBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticByteBuffer;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import java.nio.ByteBuffer;

public class ByteBufferEntry
implements Entry {
    public static final ByteBuffer NO_VALUE = null;
    private final ByteBuffer column;
    private final ByteBuffer value;
    private volatile transient RelationCache cache;

    public ByteBufferEntry(ByteBuffer column, ByteBuffer value) {
        Preconditions.checkNotNull((Object)column);
        this.column = column;
        this.value = value;
    }

    public static Entry of(ByteBuffer column, ByteBuffer value) {
        return new ByteBufferEntry(column, value);
    }

    @Override
    public int getByteSize() {
        return 182 + 2 * (this.column.limit() - this.column.position() + this.value.limit() - this.value.position());
    }

    @Override
    public StaticBuffer getColumn() {
        return new StaticByteBuffer(this.column);
    }

    @Override
    public StaticBuffer getValue() {
        return new StaticByteBuffer(this.value);
    }

    @Override
    public ReadBuffer getReadColumn() {
        return new ReadByteBuffer(this.column);
    }

    @Override
    public ReadBuffer getReadValue() {
        return new ReadByteBuffer(this.value);
    }

    @Override
    public byte[] getArrayColumn() {
        return ByteBufferUtil.getArray(this.column);
    }

    @Override
    public byte[] getArrayValue() {
        return ByteBufferUtil.getArray(this.value);
    }

    @Override
    public ByteBuffer getByteBufferColumn() {
        return this.column.duplicate();
    }

    @Override
    public ByteBuffer getByteBufferValue() {
        return this.value.duplicate();
    }

    public int hashCode() {
        return ByteBufferUtil.hashcode(this.column);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entry)) {
            return false;
        }
        if (obj instanceof ByteBufferEntry) {
            return ByteBufferUtil.equals(this.column, ((ByteBufferEntry)obj).column);
        }
        return this.getColumn().equals(((Entry)obj).getColumn());
    }

    public String toString() {
        return ByteBufferUtil.toString(this.column, "-") + "->" + ByteBufferUtil.toString(this.value, "-");
    }

    @Override
    public int compareTo(Entry entry) {
        if (entry instanceof ByteBufferEntry) {
            return ByteBufferUtil.compare(this.column, ((ByteBufferEntry)entry).column);
        }
        return ByteBufferUtil.compare(this.getColumn(), entry.getColumn());
    }

    @Override
    public RelationCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(RelationCache cache) {
        Preconditions.checkNotNull((Object)cache);
        this.cache = cache;
    }
}

