/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.BufferTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import java.util.List;

public class BufferedKeyColumnValueStore
implements KeyColumnValueStore {
    private final KeyColumnValueStore store;
    private final boolean bufferEnabled;

    public BufferedKeyColumnValueStore(KeyColumnValueStore store, boolean bufferEnabled) {
        Preconditions.checkNotNull((Object)store);
        this.store = store;
        this.bufferEnabled = bufferEnabled;
    }

    private final StoreTransaction getTx(StoreTransaction txh) {
        assert (txh instanceof BufferTransaction);
        return ((BufferTransaction)txh).getWrappedTransactionHandle();
    }

    @Override
    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws StorageException {
        return this.store.containsKey(key, this.getTx(txh));
    }

    @Override
    public List<Entry> getSlice(KeySliceQuery query, StoreTransaction txh) throws StorageException {
        return this.store.getSlice(query, this.getTx(txh));
    }

    @Override
    public List<List<Entry>> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.store.getSlice(keys, query, this.getTx(txh));
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        if (this.bufferEnabled) {
            assert (txh instanceof BufferTransaction);
            ((BufferTransaction)txh).mutate(this.store.getName(), key, additions, deletions);
        } else {
            this.store.mutate(key, additions, deletions, this.getTx(txh));
        }
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        this.store.acquireLock(key, column, expectedValue, this.getTx(txh));
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery keyQuery, StoreTransaction txh) throws StorageException {
        return this.store.getKeys(keyQuery, this.getTx(txh));
    }

    @Override
    public KeyIterator getKeys(SliceQuery columnQuery, StoreTransaction txh) throws StorageException {
        return this.store.getKeys(columnQuery, this.getTx(txh));
    }

    @Override
    public StaticBuffer[] getLocalKeyPartition() throws StorageException {
        return this.store.getLocalKeyPartition();
    }

    @Override
    public String getName() {
        return this.store.getName();
    }

    @Override
    public void close() throws StorageException {
        this.store.close();
    }
}

