/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TransactionHandle;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexTransaction
implements TransactionHandle {
    private static final int DEFAULT_OUTER_MAP_SIZE = 3;
    private static final int DEFAULT_INNER_MAP_SIZE = 5;
    private final IndexProvider index;
    private final TransactionHandle indexTx;
    private final KeyInformation.IndexRetriever keyInformations;
    private Map<String, Map<String, IndexMutation>> mutations;

    public IndexTransaction(IndexProvider index, KeyInformation.IndexRetriever keyInformations) throws StorageException {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkNotNull((Object)keyInformations);
        this.index = index;
        this.keyInformations = keyInformations;
        this.indexTx = index.beginTransaction();
        Preconditions.checkNotNull((Object)this.indexTx);
        this.mutations = null;
    }

    public void add(String store, String docid, String key, Object value, boolean isNew) {
        this.getIndexMutation(store, docid, isNew, false).addition(new IndexEntry(key, value));
    }

    public void delete(String store, String docid, String key, boolean deleteAll) {
        this.getIndexMutation(store, docid, false, deleteAll).deletion(key);
    }

    private IndexMutation getIndexMutation(String store, String docid, boolean isNew, boolean isDeleted) {
        IndexMutation m;
        Map<String, IndexMutation> storeMutations;
        if (this.mutations == null) {
            this.mutations = new HashMap<String, Map<String, IndexMutation>>(3);
        }
        if ((storeMutations = this.mutations.get(store)) == null) {
            storeMutations = new HashMap<String, IndexMutation>(5);
            this.mutations.put(store, storeMutations);
        }
        if ((m = storeMutations.get(docid)) == null) {
            m = new IndexMutation(isNew, isDeleted);
            storeMutations.put(docid, m);
        }
        return m;
    }

    public void register(String store, String key, KeyInformation information) throws StorageException {
        this.index.register(store, key, information, this.indexTx);
    }

    public List<String> query(IndexQuery query) throws StorageException {
        return this.index.query(query, this.keyInformations, this.indexTx);
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query) throws StorageException {
        return this.index.query(query, this.keyInformations, this.indexTx);
    }

    @Override
    public void commit() throws StorageException {
        this.flushInternal();
        this.indexTx.commit();
    }

    @Override
    public void rollback() throws StorageException {
        this.mutations = null;
        this.indexTx.rollback();
    }

    @Override
    public void flush() throws StorageException {
        this.flushInternal();
        this.indexTx.flush();
    }

    private void flushInternal() throws StorageException {
        if (this.mutations != null && !this.mutations.isEmpty()) {
            this.index.mutate(this.mutations, this.keyInformations, this.indexTx);
            this.mutations = null;
        }
    }
}

