/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Mutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import java.util.List;

public class IndexMutation
extends Mutation<IndexEntry, String> {
    private final boolean isNew;
    private final boolean isDeleted;

    public IndexMutation(List<IndexEntry> additions, List<String> deletions, boolean isNew, boolean isDeleted) {
        super(additions, deletions);
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public IndexMutation(boolean isNew, boolean isDeleted) {
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public void merge(IndexMutation m) {
        Preconditions.checkArgument((this.isNew == m.isNew ? 1 : 0) != 0, (Object)"Incompatible new status");
        Preconditions.checkArgument((this.isDeleted == m.isDeleted ? 1 : 0) != 0, (Object)"Incompatible delete status");
        super.merge(m);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }
}

