/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.idmanagement;

import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.idmanagement.AbstractIDManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StaticBufferEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.locking.TemporaryLockingException;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.TimeUtility;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalIDManager
extends AbstractIDManager {
    private static final Logger log = LoggerFactory.getLogger(TransactionalIDManager.class);
    private static final StaticBuffer DEFAULT_COLUMN = ByteBufferUtil.zeroBuffer(1);
    private final StoreManager manager;
    private final KeyColumnValueStore idStore;

    public TransactionalIDManager(KeyColumnValueStore idStore, StoreManager manager, Configuration config) throws StorageException {
        super(config);
        this.manager = manager;
        this.idStore = idStore;
    }

    @Override
    public long[] getIDBlock(int partition) throws StorageException {
        long blockSize = this.getBlockSize(partition);
        StaticBuffer partitionKey = this.getPartitionKey(partition);
        for (int retry = 0; retry < this.idApplicationRetryCount; ++retry) {
            StoreTransaction txh = null;
            try {
                txh = this.manager.beginTransaction(new StoreTxConfig(this.metricsPrefix));
                long current = this.getCurrentID(partitionKey, txh);
                if (Long.MAX_VALUE - blockSize <= current) {
                    throw new IDPoolExhaustedException("Exhausted id block for partition [" + partition + "]");
                }
                assert (Long.MAX_VALUE - blockSize > current);
                long next = current + blockSize;
                this.idStore.mutate(partitionKey, (List<Entry>)ImmutableList.of((Object)StaticBufferEntry.of(DEFAULT_COLUMN, ByteBufferUtil.getLongBuffer(next))), KeyColumnValueStore.NO_DELETIONS, txh);
                txh.commit();
                return new long[]{current, next};
            }
            catch (StorageException e) {
                log.warn("Storage exception while allocating id block - retrying in {} ms: {}", (Object)this.idApplicationWaitMS, (Object)e);
                if (txh != null) {
                    txh.rollback();
                }
                if (this.idApplicationWaitMS <= 0L) continue;
                TimeUtility.INSTANCE.sleepUntil(System.currentTimeMillis() + this.idApplicationWaitMS, log);
                continue;
            }
        }
        throw new TemporaryLockingException("Exceeded timeout count [" + this.idApplicationRetryCount + "] when attempting to allocate next id block");
    }

    @Override
    public StaticBuffer[] getLocalIDPartition() throws StorageException {
        return this.idStore.getLocalKeyPartition();
    }

    @Override
    public void close() throws StorageException {
        this.idStore.close();
    }

    private long getCurrentID(StaticBuffer partitionKey, StoreTransaction txh) throws StorageException {
        if (!KCVSUtil.containsKeyColumn(this.idStore, partitionKey, DEFAULT_COLUMN, txh)) {
            return 1L;
        }
        long current = KCVSUtil.get(this.idStore, partitionKey, DEFAULT_COLUMN, txh).getLong(0);
        return current;
    }
}

