/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public interface StaticBuffer
extends Comparable<StaticBuffer> {
    public static final Factory<byte[]> ARRAY_FACTORY = new Factory<byte[]>(){

        @Override
        public byte[] get(byte[] array, int offset, int limit) {
            if (offset == 0 && limit == array.length) {
                return array;
            }
            return Arrays.copyOfRange(array, offset, limit);
        }
    };

    public int length();

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public char getChar(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public StaticBuffer subrange(int var1, int var2);

    public ReadBuffer asReadBuffer();

    public ByteBuffer asByteBuffer();

    public <T> T as(Factory<T> var1);

    public static interface Factory<T> {
        public T get(byte[] var1, int var2, int var3);
    }
}

