/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.idmanagement.ConsistentKeyIDManager;
import com.thinkaurelius.titan.diskstorage.idmanagement.TransactionalIDManager;
import com.thinkaurelius.titan.diskstorage.indexing.HashPrefixKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.indexing.IndexInformation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.BufferTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.BufferedKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.CachedKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ConsistencyLevel;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.CacheStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.CacheStoreManagerAdapter;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManagerAdapter;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLocker;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import com.thinkaurelius.titan.diskstorage.locking.transactional.TransactionalLockStore;
import com.thinkaurelius.titan.diskstorage.util.MetricInstrumentedStore;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.KCVSConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.TitanConstants;
import com.thinkaurelius.titan.graphdb.database.indexing.StandardIndexInformation;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backend {
    private static final Logger log;
    public static final String EDGESTORE_NAME = "edgestore";
    public static final String VERTEXINDEX_STORE_NAME = "vertexindex";
    public static final String EDGEINDEX_STORE_NAME = "edgeindex";
    public static final String ID_STORE_NAME = "titan_ids";
    public static final String TITAN_BACKEND_VERSION = "titan-version";
    public static final String MERGED_METRICS = "stores";
    public static final String LOCK_STORE_SUFFIX = "_lock_";
    public static final String SYSTEM_PROPERTIES_STORE_NAME = "system_properties";
    public static final String SYSTEM_PROPERTIES_IDENTIFIER = "general";
    public static final int THREAD_POOL_SIZE_SCALE_FACTOR = 2;
    public static final Map<String, Integer> STATIC_KEY_LENGTHS;
    private final KeyColumnValueStoreManager storeManager;
    private final StoreFeatures storeFeatures;
    private KeyColumnValueStore edgeStore;
    private KeyColumnValueStore vertexIndexStore;
    private KeyColumnValueStore edgeIndexStore;
    private IDAuthority idAuthority;
    private final Map<String, IndexProvider> indexes;
    private final int bufferSize;
    private final boolean hashPrefixIndex;
    private final boolean basicMetrics;
    private final boolean mergeBasicMetrics;
    private final int writeAttempts;
    private final int readAttempts;
    private final int persistAttemptWaittime;
    private final ExecutorService threadPool;
    private final Function<String, Locker> lockerCreator;
    private final ConcurrentHashMap<String, Locker> lockers = new ConcurrentHashMap();
    private final Configuration storageConfig;
    private static final Map<String, String> REGISTERED_STORAGE_MANAGERS;
    private static final Map<String, String> REGISTERED_INDEX_PROVIDERS;
    private final Function<String, Locker> CONSISTENT_KEY_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            KeyColumnValueStore lockerStore;
            try {
                lockerStore = Backend.this.getStore(lockerName);
            }
            catch (StorageException e) {
                throw new TitanConfigurationException("Could not retrieve store named " + lockerName + " for locker configuration", e);
            }
            return new ConsistentKeyLocker.Builder(lockerStore).fromCommonsConfig(Backend.this.storageConfig).build();
        }
    };
    private final Function<String, Locker> ASTYANAX_RECIPE_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            String expectedManagerName = "com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager";
            String actualManagerName = Backend.this.storeManager.getClass().getCanonicalName();
            Preconditions.checkArgument((boolean)expectedManagerName.equals(actualManagerName), (Object)("Astyanax Recipe locker is only supported with the Astyanax storage backend (configured:" + actualManagerName + " != required:" + expectedManagerName + ")"));
            try {
                Class<?> c = Backend.this.storeManager.getClass();
                Method method = c.getMethod("openLocker", String.class);
                Object o = method.invoke((Object)Backend.this.storeManager, lockerName);
                return (Locker)o;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find method when configuring locking with Astyanax Recipes");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access method when configuring locking with Astyanax Recipes", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke method when configuring locking with Astyanax Recipes", e);
            }
        }
    };
    private final Function<String, Locker> TEST_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            return Backend.openManagedLocker("com.thinkaurelius.titan.diskstorage.util.TestLockerManager", lockerName);
        }
    };
    private final Map<String, Function<String, Locker>> REGISTERED_LOCKERS = ImmutableMap.of((Object)"consistentkey", this.CONSISTENT_KEY_LOCKER_CREATOR, (Object)"astyanaxrecipe", this.ASTYANAX_RECIPE_LOCKER_CREATOR, (Object)"test", this.TEST_LOCKER_CREATOR);

    public Backend(Configuration storageConfig) {
        this(storageConfig, null);
    }

    public Backend(Configuration storageConfig, Configuration metricsConfig) {
        this.storageConfig = storageConfig;
        this.storeManager = Backend.getStorageManager(storageConfig);
        this.indexes = Backend.getIndexes(storageConfig);
        this.storeFeatures = this.storeManager.getFeatures();
        if (null == metricsConfig) {
            metricsConfig = new BaseConfiguration();
        }
        this.basicMetrics = GraphDatabaseConfiguration.isMetricsEnabled(storageConfig, metricsConfig);
        this.mergeBasicMetrics = GraphDatabaseConfiguration.isMetricsMergingEnabled(storageConfig, metricsConfig);
        int bufferSizeTmp = storageConfig.getInt("buffer-size", 1024);
        Preconditions.checkArgument((bufferSizeTmp >= 0 ? 1 : 0) != 0, (Object)"Buffer size must be non-negative (use 0 to disable)");
        if (!this.storeFeatures.supportsBatchMutation()) {
            this.bufferSize = 0;
            log.debug("Buffering disabled because backend does not support batch mutations");
        } else {
            this.bufferSize = bufferSizeTmp;
        }
        this.writeAttempts = storageConfig.getInt("write-attempts", 5);
        Preconditions.checkArgument((this.writeAttempts > 0 ? 1 : 0) != 0, (Object)"Write attempts must be positive");
        this.readAttempts = storageConfig.getInt("read-attempts", 3);
        Preconditions.checkArgument((this.readAttempts > 0 ? 1 : 0) != 0, (Object)"Read attempts must be positive");
        this.persistAttemptWaittime = storageConfig.getInt("attempt-wait", 250);
        Preconditions.checkArgument((this.persistAttemptWaittime > 0 ? 1 : 0) != 0, (Object)"Persistence attempt retry wait time must be non-negative");
        if (storageConfig.getBoolean("parallel-backend-ops", true)) {
            int poolsize = Math.min(1, Runtime.getRuntime().availableProcessors()) * 2;
            this.threadPool = Executors.newFixedThreadPool(poolsize);
            log.info("Initiated backend operations thread pool of size {}", (Object)poolsize);
        } else {
            this.threadPool = null;
        }
        storageConfig.setProperty("local-lock-mediator-prefix", (Object)storageConfig.getString("local-lock-mediator-prefix", this.storeManager.getName()));
        String lockBackendName = storageConfig.getString("lock-backend", "consistentkey");
        if (!this.REGISTERED_LOCKERS.containsKey(lockBackendName)) {
            throw new TitanConfigurationException("Unknown lock backend \"" + lockBackendName + "\".  Known lock backends: " + Joiner.on((String)", ").join(this.REGISTERED_LOCKERS.keySet()) + ".");
        }
        this.lockerCreator = this.REGISTERED_LOCKERS.get(lockBackendName);
        Preconditions.checkNotNull(this.lockerCreator);
        if (this.storeFeatures.isDistributed() && this.storeFeatures.isKeyOrdered()) {
            log.debug("Wrapping index store with HashPrefix");
            this.hashPrefixIndex = true;
        } else {
            this.hashPrefixIndex = false;
        }
    }

    private KeyColumnValueStore getLockStore(KeyColumnValueStore store) throws StorageException {
        return this.getLockStore(store, true);
    }

    private KeyColumnValueStore getLockStore(KeyColumnValueStore store, boolean lockEnabled) throws StorageException {
        if (!this.storeFeatures.supportsLocking()) {
            if (this.storeFeatures.supportsTransactions()) {
                store = new TransactionalLockStore(store);
            } else if (this.storeFeatures.supportsConsistentKeyOperations()) {
                if (lockEnabled) {
                    String lockerName = store.getName() + LOCK_STORE_SUFFIX;
                    store = new ExpectedValueCheckingStore(store, this.getLocker(lockerName));
                } else {
                    store = new ExpectedValueCheckingStore(store, null);
                }
            } else {
                throw new IllegalArgumentException("Store needs to support some form of locking");
            }
        }
        return store;
    }

    private Locker getLocker(String lockerName) {
        Locker x;
        Preconditions.checkNotNull((Object)lockerName);
        Locker l = this.lockers.get(lockerName);
        if (null == l && null != (x = this.lockers.putIfAbsent(lockerName, l = (Locker)this.lockerCreator.apply((Object)lockerName)))) {
            l = x;
        }
        return l;
    }

    private KeyColumnValueStore getBufferStore(String name) throws StorageException {
        Preconditions.checkArgument((this.bufferSize <= 1 || this.storeManager.getFeatures().supportsBatchMutation() ? 1 : 0) != 0);
        KeyColumnValueStore store = null;
        store = this.storeManager.openDatabase(name);
        if (this.bufferSize > 1) {
            store = new BufferedKeyColumnValueStore(store, true);
        }
        store = new CachedKeyColumnValueStore(store);
        return store;
    }

    private KeyColumnValueStore getStore(String name) throws StorageException {
        KeyColumnValueStore store = this.storeManager.openDatabase(name);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Configuration config) {
        try {
            KeyColumnValueStore idStore = this.getStore(ID_STORE_NAME);
            if (this.basicMetrics) {
                idStore = new MetricInstrumentedStore(idStore, this.getMetricsStoreName("idStore"));
            }
            this.idAuthority = null;
            if (this.storeFeatures.supportsTransactions()) {
                this.idAuthority = new TransactionalIDManager(idStore, this.storeManager, config);
            } else if (this.storeFeatures.supportsConsistentKeyOperations()) {
                this.idAuthority = new ConsistentKeyIDManager(idStore, this.storeManager, config);
            } else {
                throw new IllegalStateException("Store needs to support consistent key or transactional operations for ID manager to guarantee proper id allocations");
            }
            this.edgeStore = this.getLockStore(this.getBufferStore(EDGESTORE_NAME));
            this.vertexIndexStore = this.getLockStore(this.getBufferStore(VERTEXINDEX_STORE_NAME));
            this.edgeIndexStore = this.getLockStore(this.getBufferStore(EDGEINDEX_STORE_NAME), false);
            if (this.hashPrefixIndex) {
                this.vertexIndexStore = new HashPrefixKeyColumnValueStore(this.vertexIndexStore, 4);
                this.edgeIndexStore = new HashPrefixKeyColumnValueStore(this.edgeIndexStore, 4);
            }
            if (this.basicMetrics) {
                this.edgeStore = new MetricInstrumentedStore(this.edgeStore, this.getMetricsStoreName("edgeStore"));
                this.vertexIndexStore = new MetricInstrumentedStore(this.vertexIndexStore, this.getMetricsStoreName("vertexIndexStore"));
                this.edgeIndexStore = new MetricInstrumentedStore(this.edgeIndexStore, this.getMetricsStoreName("edgeIndexStore"));
            }
            String version = null;
            KCVSConfiguration systemConfig = new KCVSConfiguration(this.storeManager, SYSTEM_PROPERTIES_STORE_NAME, SYSTEM_PROPERTIES_IDENTIFIER);
            try {
                systemConfig.setMaxOperationWaitTime(config.getLong("setup-wait", 60000L));
                version = systemConfig.getConfigurationProperty(TITAN_BACKEND_VERSION);
                if (version == null) {
                    systemConfig.setConfigurationProperty(TITAN_BACKEND_VERSION, TitanConstants.VERSION);
                    version = TitanConstants.VERSION;
                }
            }
            finally {
                systemConfig.close();
            }
            Preconditions.checkState((version != null ? 1 : 0) != 0, (Object)"Could not read version from storage backend");
            if (!TitanConstants.VERSION.equals(version) && !TitanConstants.COMPATIBLE_VERSIONS.contains(version)) {
                throw new TitanException("StorageBackend version is incompatible with current Titan version: " + version + " vs. " + TitanConstants.VERSION);
            }
        }
        catch (StorageException e) {
            throw new TitanException("Could not initialize backend", e);
        }
    }

    public Map<String, IndexInformation> getIndexInformation() {
        ImmutableMap.Builder copy = ImmutableMap.builder();
        copy.putAll(this.indexes);
        copy.put((Object)"standard", (Object)StandardIndexInformation.INSTANCE);
        return copy.build();
    }

    private String getMetricsStoreName(String storeName) {
        return this.mergeBasicMetrics ? MERGED_METRICS : storeName;
    }

    private static final KeyColumnValueStoreManager getStorageManager(Configuration storageConfig) {
        StoreManager manager = (StoreManager)Backend.getImplementationClass(storageConfig, "backend", "local", REGISTERED_STORAGE_MANAGERS);
        if (manager instanceof OrderedKeyValueStoreManager) {
            manager = new OrderedKeyValueStoreManagerAdapter((OrderedKeyValueStoreManager)manager, STATIC_KEY_LENGTHS);
        } else if (manager instanceof CacheStoreManager) {
            manager = new CacheStoreManagerAdapter((CacheStoreManager)manager);
        }
        Preconditions.checkArgument((boolean)(manager instanceof KeyColumnValueStoreManager));
        return (KeyColumnValueStoreManager)manager;
    }

    private static final Map<String, IndexProvider> getIndexes(Configuration storageConfig) {
        Configuration indexConfig = storageConfig.subset("index");
        Set<String> indexes = GraphDatabaseConfiguration.getUnqiuePrefixes(indexConfig);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String index : indexes) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)index), (String)"Invalid index name [%s]", (Object[])new Object[]{index});
            Configuration config = indexConfig.subset(index);
            log.info("Configuring index [{}] based on: \n {}", (Object)index, (Object)GraphDatabaseConfiguration.toString(config));
            IndexProvider provider = (IndexProvider)Backend.getImplementationClass(config, "backend", "lucene", REGISTERED_INDEX_PROVIDERS);
            Preconditions.checkNotNull((Object)provider);
            builder.put((Object)index, (Object)provider);
        }
        return builder.build();
    }

    public static final <T> T instantiate(String clazzname, Object ... constructorArgs) {
        try {
            Class<?> clazz = Class.forName(clazzname);
            Constructor<?> constructor = clazz.getConstructor(Configuration.class);
            Object instance = constructor.newInstance(constructorArgs);
            return (T)instance;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + clazzname);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Configured backend implementation does not have required constructor: " + clazzname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
    }

    public static final <T> T getImplementationClass(Configuration config, String key, String defaultValue, Map<String, String> registeredImpls) {
        String clazzname = config.getString(key, defaultValue);
        if (registeredImpls.containsKey(clazzname.toLowerCase())) {
            clazzname = registeredImpls.get(clazzname.toLowerCase());
        }
        return Backend.instantiate(clazzname, config);
    }

    public IDAuthority getIDAuthority() {
        Preconditions.checkNotNull((Object)this.idAuthority, (Object)"Backend has not yet been initialized");
        return this.idAuthority;
    }

    public StoreFeatures getStoreFeatures() {
        return this.storeManager.getFeatures();
    }

    public BackendTransaction beginTransaction(TransactionConfiguration configuration, KeyInformation.Retriever indexKeyRetriever) throws StorageException {
        StoreTxConfig txConfig = new StoreTxConfig(configuration.getMetricsPrefix());
        if (configuration.hasTimestamp()) {
            txConfig.setTimestamp(configuration.getTimestamp());
        }
        StoreTransaction tx = this.storeManager.beginTransaction(txConfig);
        if (this.bufferSize > 1) {
            Preconditions.checkArgument((boolean)this.storeManager.getFeatures().supportsBatchMutation());
            tx = new BufferTransaction(tx, this.storeManager, this.bufferSize, this.writeAttempts, this.persistAttemptWaittime);
        }
        if (!this.storeFeatures.supportsLocking() && !this.storeFeatures.supportsTransactions() && this.storeFeatures.supportsConsistentKeyOperations()) {
            txConfig = new StoreTxConfig(ConsistencyLevel.KEY_CONSISTENT, configuration.getMetricsPrefix());
            if (configuration.hasTimestamp()) {
                txConfig.setTimestamp(configuration.getTimestamp());
            }
            tx = new ExpectedValueCheckingTransaction(tx, this.storeManager.beginTransaction(txConfig), this.readAttempts);
        }
        HashMap<String, IndexTransaction> indexTx = new HashMap<String, IndexTransaction>(this.indexes.size());
        for (Map.Entry<String, IndexProvider> entry : this.indexes.entrySet()) {
            indexTx.put(entry.getKey(), new IndexTransaction(entry.getValue(), indexKeyRetriever.get(entry.getKey())));
        }
        return new BackendTransaction(tx, this.storeManager.getFeatures(), this.edgeStore, this.vertexIndexStore, this.edgeIndexStore, this.readAttempts, this.persistAttemptWaittime, indexTx, this.threadPool);
    }

    public void close() throws StorageException {
        this.edgeStore.close();
        this.vertexIndexStore.close();
        this.edgeIndexStore.close();
        this.idAuthority.close();
        this.storeManager.close();
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        for (IndexProvider index : this.indexes.values()) {
            index.close();
        }
    }

    public void clearStorage() throws StorageException {
        this.edgeStore.close();
        this.vertexIndexStore.close();
        this.edgeIndexStore.close();
        this.idAuthority.close();
        this.storeManager.clearStorage();
        for (IndexProvider index : this.indexes.values()) {
            index.clearStorage();
        }
    }

    private static Locker openManagedLocker(String classname, String lockerName) {
        try {
            Class<?> c = Class.forName(classname);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            Method method = c.getMethod("openLocker", String.class);
            Object o = method.invoke(instance, lockerName);
            return (Locker)o;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + classname, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find method when configuring locking for: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access method when configuring locking for: " + classname, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not invoke method when configuring locking for: " + classname, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + classname, e);
        }
    }

    public static final void registerShorthands(Properties props, String prefix, Map<String, String> shorthands) {
        for (String key : props.stringPropertyNames()) {
            if (!key.toLowerCase().startsWith(prefix)) continue;
            String shorthand = key.substring(prefix.length()).toLowerCase();
            String clazz = props.getProperty(key);
            shorthands.put(shorthand, clazz);
            log.debug("Registering shorthand [{}] for [{}]", (Object)shorthand, (Object)clazz);
        }
    }

    static {
        Properties props;
        log = LoggerFactory.getLogger(Backend.class);
        STATIC_KEY_LENGTHS = new HashMap<String, Integer>(){
            {
                this.put(Backend.EDGESTORE_NAME, 8);
                this.put("edgestore_lock_", 8);
                this.put(Backend.ID_STORE_NAME, 4);
            }
        };
        REGISTERED_STORAGE_MANAGERS = new HashMap<String, String>(){
            {
                this.put("local", "com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager");
                this.put("berkeleyje", "com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager");
                this.put("persistit", "com.thinkaurelius.titan.diskstorage.persistit.PersistitStoreManager");
                this.put("hazelcast", "com.thinkaurelius.titan.diskstorage.hazelcast.HazelcastCacheStoreManager");
                this.put("hazelcastcache", "com.thinkaurelius.titan.diskstorage.hazelcast.HazelcastCacheStoreManager");
                this.put("infinispan", "com.thinkaurelius.titan.diskstorage.infinispan.InfinispanCacheStoreManager");
                this.put("cassandra", "com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager");
                this.put("cassandrathrift", "com.thinkaurelius.titan.diskstorage.cassandra.thrift.CassandraThriftStoreManager");
                this.put("astyanax", "com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager");
                this.put("hbase", "com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager");
                this.put("embeddedcassandra", "com.thinkaurelius.titan.diskstorage.cassandra.embedded.CassandraEmbeddedStoreManager");
                this.put("inmemory", "com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory.InMemoryStoreManager");
            }
        };
        REGISTERED_INDEX_PROVIDERS = new HashMap<String, String>(){
            {
                this.put("lucene", "com.thinkaurelius.titan.diskstorage.lucene.LuceneIndex");
                this.put("elasticsearch", "com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex");
                this.put("es", "com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex");
            }
        };
        try {
            props = new Properties();
            InputStream in = TitanFactory.class.getClassLoader().getResourceAsStream("titan.properties");
            if (in != null && in.available() > 0) {
                props.load(in);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Backend.registerShorthands(props, "storage.", REGISTERED_STORAGE_MANAGERS);
        Backend.registerShorthands(props, "index.", REGISTERED_INDEX_PROVIDERS);
    }
}

