/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Parameter<V> {
    private String key;
    private V value;

    private Parameter() {
    }

    public Parameter(String key, V value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"Invalid key");
        this.key = key;
        this.value = value;
    }

    public static <V> Parameter<V> of(String key, V value) {
        return new Parameter<V>(key, value);
    }

    public String getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append(this.value).toHashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        Parameter other = (Parameter)oth;
        return this.key.equals(other.key) && (this.value == other.value || this.value != null && this.value.equals(other.value));
    }

    public String toString() {
        return "(" + this.key + ":" + this.value + ")";
    }
}

