/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;

public enum Mapping {
    DEFAULT,
    TEXT,
    STRING;

    public static final String MAPPING_PREFIX = "mapping";

    public static Mapping getMapping(KeyInformation information) {
        Mapping mapping = null;
        for (Parameter p : information.getParameters()) {
            if (!p.getKey().equalsIgnoreCase(MAPPING_PREFIX)) continue;
            Object value = p.getValue();
            Preconditions.checkArgument((value != null && value instanceof Mapping ? 1 : 0) != 0, (String)"Invalid mapping for specified: %s", (Object[])new Object[]{value});
            Preconditions.checkArgument((mapping == null ? 1 : 0) != 0, (Object)"Multiple mappings specified");
            mapping = (Mapping)((Object)value);
        }
        if (mapping == null) {
            mapping = DEFAULT;
        }
        return mapping;
    }

    public static Mapping getMapping(String store, String key, KeyInformation.IndexRetriever informations) {
        KeyInformation ki = informations.get(store, key);
        Preconditions.checkArgument((ki != null ? 1 : 0) != 0, (String)"Could not find key information for: %s", (Object[])new Object[]{key});
        return Mapping.getMapping(ki);
    }
}

