/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJETx
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJETx.class);
    private Transaction tx;
    private List<Cursor> openCursors = new ArrayList<Cursor>();

    public BerkeleyJETx(Transaction t, StoreTxConfig config) {
        super(config);
        this.tx = t;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCursor(Cursor cursor) {
        Preconditions.checkArgument((cursor != null ? 1 : 0) != 0);
        List<Cursor> list = this.openCursors;
        synchronized (list) {
            this.openCursors.add(cursor);
        }
    }

    private void closeOpenIterators() throws StorageException {
        for (Cursor cursor : this.openCursors) {
            cursor.close();
        }
    }

    public synchronized void rollback() throws StorageException {
        super.rollback();
        if (this.tx == null) {
            return;
        }
        try {
            this.closeOpenIterators();
            this.tx.abort();
            this.tx = null;
        }
        catch (DatabaseException e) {
            throw new PermanentStorageException((Throwable)e);
        }
    }

    public synchronized void commit() throws StorageException {
        super.commit();
        if (this.tx == null) {
            return;
        }
        try {
            this.closeOpenIterators();
            this.tx.commit();
            this.tx = null;
        }
        catch (DatabaseException e) {
            throw new PermanentStorageException((Throwable)e);
        }
    }
}

