/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEKeyValueStore;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJETx;
import com.thinkaurelius.titan.diskstorage.common.LocalStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJEStoreManager
extends LocalStoreManager
implements OrderedKeyValueStoreManager {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJEStoreManager.class);
    public static final String CACHE_KEY = "cache-percentage";
    public static final int CACHE_DEFAULT = 65;
    private final Map<String, BerkeleyJEKeyValueStore> stores = new HashMap<String, BerkeleyJEKeyValueStore>();
    protected Environment environment;
    protected final StoreFeatures features;

    public BerkeleyJEStoreManager(Configuration configuration) throws StorageException {
        super(configuration);
        if (!this.transactional) {
            log.warn("Transactions are disabled. Ensure that there is at most one Titan instance interacting with this BerkeleyDB instance, otherwise your database may corrupt.");
        }
        int cachePercentage = configuration.getInt(CACHE_KEY, 65);
        this.initialize(cachePercentage);
        this.features = new StoreFeatures();
        this.features.supportsOrderedScan = true;
        this.features.supportsUnorderedScan = false;
        this.features.supportsBatchMutation = false;
        this.features.supportsTransactions = true;
        this.features.supportsConsistentKeyOperations = false;
        this.features.supportsLocking = true;
        this.features.isKeyOrdered = true;
        this.features.isDistributed = false;
        this.features.hasLocalKeyPartition = false;
        this.features.supportsMultiQuery = false;
    }

    private void initialize(int cachePercent) throws StorageException {
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(this.transactional);
            envConfig.setCachePercent(cachePercent);
            if (this.batchLoading) {
                envConfig.setConfigParam("je.env.runCheckpointer", "false");
                envConfig.setConfigParam("je.env.runCleaner", "false");
            }
            this.environment = new Environment(this.directory, envConfig);
        }
        catch (DatabaseException e) {
            throw new PermanentStorageException("Error during BerkeleyJE initialization: ", (Throwable)e);
        }
    }

    public StoreFeatures getFeatures() {
        return this.features;
    }

    public BerkeleyJETx beginTransaction(StoreTxConfig config) throws StorageException {
        try {
            Transaction tx = null;
            if (this.transactional) {
                tx = this.environment.beginTransaction(null, null);
            }
            return new BerkeleyJETx(tx, config);
        }
        catch (DatabaseException e) {
            throw new PermanentStorageException("Could not start BerkeleyJE transaction", (Throwable)e);
        }
    }

    public BerkeleyJEKeyValueStore openDatabase(String name) throws StorageException {
        Preconditions.checkNotNull((Object)name);
        if (this.stores.containsKey(name)) {
            BerkeleyJEKeyValueStore store = this.stores.get(name);
            return store;
        }
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(this.isReadOnly);
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(this.transactional);
            dbConfig.setKeyPrefixing(true);
            if (this.batchLoading) {
                dbConfig.setDeferredWrite(true);
            }
            Database db = this.environment.openDatabase(null, name, dbConfig);
            BerkeleyJEKeyValueStore store = new BerkeleyJEKeyValueStore(name, db, this);
            this.stores.put(name, store);
            return store;
        }
        catch (DatabaseException e) {
            throw new PermanentStorageException("Could not open BerkeleyJE data store", (Throwable)e);
        }
    }

    public void mutateMany(Map<String, KVMutation> mutations, StoreTransaction txh) throws StorageException {
        throw new UnsupportedOperationException();
    }

    void removeDatabase(BerkeleyJEKeyValueStore db) {
        if (!this.stores.containsKey(db.getName())) {
            throw new IllegalArgumentException("Tried to remove an unkown database from the storage manager");
        }
        this.stores.remove(db.getName());
    }

    public void close() throws StorageException {
        if (this.environment != null) {
            if (!this.stores.isEmpty()) {
                throw new IllegalStateException("Cannot shutdown manager since some databases are still open");
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.environment.close();
            }
            catch (DatabaseException e) {
                throw new PermanentStorageException("Could not close BerkeleyJE database", (Throwable)e);
            }
        }
    }

    public void clearStorage() throws StorageException {
        if (!this.stores.isEmpty()) {
            throw new IllegalStateException("Cannot delete store, since database is open: " + this.stores.keySet().toString());
        }
        Transaction tx = null;
        for (String db : this.environment.getDatabaseNames()) {
            this.environment.removeDatabase(tx, db);
        }
        this.close();
        IOUtils.deleteFromDirectory((File)this.directory);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.directory.toString();
    }
}

