/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import java.sql.SQLException;

public class IndicDataParcel
extends Parcel {
    private ParameterProperties.ParameterSet m_parameterSet;
    private byte[] nullIndicatorBits;

    public IndicDataParcel(int n, GenericTeradataConnection genericTeradataConnection, boolean bl) {
        super(genericTeradataConnection);
        this.setAltHeader(bl);
        this.setFlavor(bl ? (short)-32700 : 68);
        this.setLength(n + IndicDataParcel.calculateHeaderLength(bl));
        this.createBuffer(this.getLength());
    }

    public void setParameters(ParameterProperties.ParameterSet parameterSet) {
        this.m_parameterSet = parameterSet;
    }

    public void setNullIndicatorBits(byte[] byArray) {
        this.nullIndicatorBits = byArray;
    }

    @Override
    public TDPacketStream toStream() throws SQLException {
        if (this.buffer == null) {
            this.createBuffer(this.getLength());
        }
        super.toStream();
        this.buffer.put(this.nullIndicatorBits);
        IndicDataParcel.putPreparedParams(this.buffer, this.m_parameterSet);
        this.buffer.flip();
        return this.buffer;
    }

    private static void putPreparedParams(TDPacketStream tDPacketStream, ParameterProperties.ParameterSet parameterSet) throws SQLException {
        for (int i = 1; parameterSet != null && i <= parameterSet.getNumberOfParamValues(); ++i) {
            if (parameterSet.getParamType(i) == 2) continue;
            if (parameterSet.isArray(i)) {
                short s = parameterSet.getAttributeParamSet(i).getArrayDataSize();
                tDPacketStream.putShort(s);
                if (!parameterSet.isNullValue(i)) {
                    tDPacketStream.putInt(parameterSet.getAttributeParamSet(i).getNumberOfParamValues());
                    tDPacketStream.put(parameterSet.getAttributeParamSet(i).getNullIndicatorBits());
                }
            }
            if (parameterSet.isStruct(i) || parameterSet.isArray(i)) {
                IndicDataParcel.putPreparedParams(tDPacketStream, parameterSet.getAttributeParamSet(i));
                continue;
            }
            tDPacketStream.put(parameterSet.getBinaryValue(i));
        }
    }
}

