/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.federecio.dropwizard.swagger.SwaggerOAuth2Configuration;
import io.federecio.dropwizard.swagger.SwaggerView;
import io.federecio.dropwizard.swagger.SwaggerViewConfiguration;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/swagger")
@Produces(value={"text/html"})
public class SwaggerResource {
    static final String PATH = "/swagger";
    private final SwaggerViewConfiguration viewConfiguration;
    private final SwaggerOAuth2Configuration oAuth2Configuration;
    private final String contextRoot;
    private final String urlPattern;
    private final String customJavascriptPath;

    public SwaggerResource(String urlPattern, SwaggerViewConfiguration viewConfiguration, SwaggerOAuth2Configuration oAuth2Configuration) {
        this.urlPattern = urlPattern;
        this.viewConfiguration = viewConfiguration.clone();
        this.oAuth2Configuration = oAuth2Configuration.clone();
        this.contextRoot = "/";
        this.customJavascriptPath = null;
    }

    public SwaggerResource(String urlPattern, SwaggerViewConfiguration viewConfiguration, SwaggerOAuth2Configuration oAuth2Configuration, String contextRoot) {
        this.viewConfiguration = viewConfiguration.clone();
        this.oAuth2Configuration = oAuth2Configuration.clone();
        this.urlPattern = urlPattern;
        this.contextRoot = contextRoot;
        this.customJavascriptPath = null;
    }

    public SwaggerResource(String urlPattern, SwaggerViewConfiguration viewConfiguration, SwaggerOAuth2Configuration oAuth2Configuration, String contextRoot, String customJavascriptPath) {
        this.viewConfiguration = viewConfiguration.clone();
        this.oAuth2Configuration = oAuth2Configuration.clone();
        this.urlPattern = urlPattern;
        this.contextRoot = contextRoot;
        this.customJavascriptPath = customJavascriptPath;
    }

    @GET
    public SwaggerView get() {
        return new SwaggerView(this.contextRoot, this.urlPattern, this.viewConfiguration, this.oAuth2Configuration, this.customJavascriptPath);
    }
}

