/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.federecio.dropwizard.swagger.SwaggerOAuth2Configuration;
import io.federecio.dropwizard.swagger.SwaggerViewConfiguration;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SwaggerBundleConfiguration
implements Cloneable {
    @NotEmpty
    private String resourcePackage = "";
    private @Nullable String title;
    private @Nullable String version;
    private @Nullable String description;
    private @Nullable String termsOfServiceUrl;
    private @Nullable String contact;
    private @Nullable String contactEmail;
    private @Nullable String contactUrl;
    private @Nullable String license;
    private @Nullable String licenseUrl;
    private @Nullable String customJavascript;
    private SwaggerViewConfiguration swaggerViewConfiguration = new SwaggerViewConfiguration();
    private SwaggerOAuth2Configuration swaggerOAuth2Configuration = new SwaggerOAuth2Configuration();
    private boolean prettyPrint = true;
    private @Nullable String host;
    private String contextRoot = "/";
    private String[] schemes = new String[0];
    private boolean enabled = true;
    private boolean includeSwaggerResource = true;
    private boolean readAllResources = true;
    private @Nullable String uriPrefix;

    @JsonProperty
    public String getResourcePackage() {
        return this.resourcePackage;
    }

    @JsonProperty
    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    @JsonProperty
    public @Nullable String getTitle() {
        return this.title;
    }

    @JsonProperty
    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @JsonProperty
    public @Nullable String getVersion() {
        return this.version;
    }

    @JsonProperty
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @JsonProperty
    public @Nullable String getDescription() {
        return this.description;
    }

    @JsonProperty
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @JsonProperty
    public @Nullable String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    @JsonProperty
    public void setTermsOfServiceUrl(@Nullable String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    @JsonProperty
    public @Nullable String getContact() {
        return this.contact;
    }

    @JsonProperty
    public void setContact(@Nullable String contact) {
        this.contact = contact;
    }

    @JsonProperty
    public @Nullable String getContactEmail() {
        return this.contactEmail;
    }

    @JsonProperty
    public void setContactEmail(@Nullable String contactEmail) {
        this.contactEmail = contactEmail;
    }

    @JsonProperty
    public @Nullable String getContactUrl() {
        return this.contactUrl;
    }

    @JsonProperty
    public void setContactUrl(@Nullable String contactUrl) {
        this.contactUrl = contactUrl;
    }

    @JsonProperty
    public @Nullable String getLicense() {
        return this.license;
    }

    @JsonProperty
    public void setLicense(@Nullable String license) {
        this.license = license;
    }

    @JsonProperty
    public @Nullable String getLicenseUrl() {
        return this.licenseUrl;
    }

    @JsonProperty
    public void setLicenseUrl(@Nullable String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    @JsonProperty
    public @Nullable String getUriPrefix() {
        return this.uriPrefix;
    }

    @JsonProperty
    public void setUriPrefix(@Nullable String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    @JsonProperty
    public SwaggerViewConfiguration getSwaggerViewConfiguration() {
        return this.swaggerViewConfiguration.clone();
    }

    @JsonProperty
    public void setSwaggerViewConfiguration(SwaggerViewConfiguration swaggerViewConfiguration) {
        this.swaggerViewConfiguration = swaggerViewConfiguration.clone();
    }

    @JsonProperty
    public SwaggerOAuth2Configuration getSwaggerOAuth2Configuration() {
        return this.swaggerOAuth2Configuration.clone();
    }

    @JsonProperty(value="oauth2")
    public void setSwaggerOAuth2Configuration(SwaggerOAuth2Configuration swaggerOAuth2Configuration) {
        this.swaggerOAuth2Configuration = swaggerOAuth2Configuration.clone();
    }

    @JsonProperty
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @JsonProperty
    public void setIsPrettyPrint(boolean isPrettyPrint) {
        this.prettyPrint = isPrettyPrint;
    }

    @JsonProperty
    public @Nullable String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(@Nullable String host) {
        this.host = host;
    }

    @JsonProperty
    public String getContextRoot() {
        return this.contextRoot;
    }

    @JsonProperty
    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @JsonProperty
    public String[] getSchemes() {
        return Arrays.copyOf(this.schemes, this.schemes.length);
    }

    @JsonProperty
    public void setSchemes(String[] schemes) {
        this.schemes = Arrays.copyOf(schemes, schemes.length);
    }

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setIsEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    @JsonProperty
    public boolean isIncludeSwaggerResource() {
        return this.includeSwaggerResource;
    }

    @JsonProperty
    public void setIncludeSwaggerResource(boolean include) {
        this.includeSwaggerResource = include;
    }

    @JsonProperty
    public @Nullable String getCustomJavascript() {
        return this.customJavascript;
    }

    @JsonProperty
    public void setCustomJavascript(@Nullable String customJavascript) {
        this.customJavascript = customJavascript;
    }

    @JsonProperty
    public boolean isReadAllResources() {
        return this.readAllResources;
    }

    @JsonProperty
    public void setReadAllResources(boolean include) {
        this.readAllResources = include;
    }

    @JsonIgnore
    public SwaggerConfiguration build() {
        if (Strings.isNullOrEmpty((String)this.resourcePackage)) {
            throw new IllegalStateException("Resource package needs to be specified for Swagger to correctly detect annotated resources");
        }
        OpenAPI oas = new OpenAPI();
        Info info = new Info().title(this.title).version(this.version).description(this.description).contact(new Contact().email(this.contactEmail).name(this.contact).url(this.contactUrl)).license(new License().name(this.license).url(this.licenseUrl)).termsOfService(this.termsOfServiceUrl);
        String[] exclusions = new String[]{"/swagger"};
        return new SwaggerConfiguration().openAPI(oas.info(info)).prettyPrint(Boolean.valueOf(this.prettyPrint)).readAllResources(Boolean.valueOf(this.readAllResources)).ignoredRoutes((Collection)Arrays.stream(exclusions).collect(Collectors.toSet())).resourcePackages(Arrays.stream(this.resourcePackage.split(",")).collect(Collectors.toSet()));
    }

    public SwaggerBundleConfiguration clone() {
        try {
            SwaggerBundleConfiguration clone = (SwaggerBundleConfiguration)super.clone();
            clone.setSwaggerViewConfiguration(this.swaggerViewConfiguration);
            clone.setSwaggerOAuth2Configuration(this.swaggerOAuth2Configuration);
            clone.schemes = (String[])this.schemes.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

