/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.views.common.ViewBundle;
import io.federecio.dropwizard.swagger.ConfigurationHelper;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.federecio.dropwizard.swagger.SwaggerResource;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.jaxrs2.SwaggerSerializers;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;

public abstract class SwaggerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new ViewBundle());
        ModelConverters.getInstance().addConverter((ModelConverter)new ModelResolver(bootstrap.getObjectMapper()));
    }

    public void run(T configuration, Environment environment) throws Exception {
        SwaggerBundleConfiguration swaggerBundleConfiguration = this.getSwaggerBundleConfiguration(configuration);
        if (swaggerBundleConfiguration == null) {
            throw new IllegalStateException("You need to provide an instance of SwaggerBundleConfiguration");
        }
        if (!swaggerBundleConfiguration.isEnabled()) {
            return;
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper((Configuration)configuration, swaggerBundleConfiguration);
        new AssetsBundle("/swagger-static", configurationHelper.getSwaggerUriPath(), null, "swagger-assets").run(configuration, environment);
        new AssetsBundle("/swagger-static/oauth2-redirect.html", configurationHelper.getOAuth2RedirectUriPath(), null, "swagger-oauth2-connect").run(configuration, environment);
        SwaggerConfiguration oasConfiguration = swaggerBundleConfiguration.build();
        new JaxrsOpenApiContextBuilder().openApiConfiguration((OpenAPIConfiguration)oasConfiguration).buildContext(true);
        environment.jersey().register((Object)new OpenApiResource());
        environment.jersey().register((Object)new SwaggerSerializers());
        if (swaggerBundleConfiguration.isIncludeSwaggerResource()) {
            environment.jersey().register((Object)new SwaggerResource(configurationHelper.getUrlPattern(), swaggerBundleConfiguration.getSwaggerViewConfiguration(), swaggerBundleConfiguration.getSwaggerOAuth2Configuration(), swaggerBundleConfiguration.getContextRoot(), swaggerBundleConfiguration.getCustomJavascript()));
        }
    }

    protected abstract SwaggerBundleConfiguration getSwaggerBundleConfiguration(T var1);
}

