/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.dropwizard.core.Configuration;
import io.dropwizard.core.server.DefaultServerFactory;
import io.dropwizard.core.server.ServerFactory;
import io.dropwizard.core.server.SimpleServerFactory;
import io.dropwizard.health.HealthFactory;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import java.util.Optional;

public class ConfigurationHelper {
    private final Configuration configuration = new Configuration();
    private final SwaggerBundleConfiguration swaggerBundleConfiguration;

    public ConfigurationHelper(Configuration configuration, SwaggerBundleConfiguration swaggerBundleConfiguration) {
        this.configuration.setAdminFactory(configuration.getAdminFactory());
        if (configuration.getHealthFactory().isPresent()) {
            this.configuration.setHealthFactory((HealthFactory)configuration.getHealthFactory().get());
        }
        this.configuration.setLoggingFactory(configuration.getLoggingFactory());
        this.configuration.setServerFactory(configuration.getServerFactory());
        this.configuration.setMetricsFactory(configuration.getMetricsFactory());
        this.swaggerBundleConfiguration = swaggerBundleConfiguration.clone();
    }

    public String getJerseyRootPath() {
        if (this.swaggerBundleConfiguration.getUriPrefix() != null) {
            return this.swaggerBundleConfiguration.getUriPrefix();
        }
        ServerFactory serverFactory = this.configuration.getServerFactory();
        Optional rootPath = serverFactory instanceof SimpleServerFactory ? ((SimpleServerFactory)serverFactory).getJerseyRootPath() : ((DefaultServerFactory)serverFactory).getJerseyRootPath();
        return this.stripUrlSlashes(rootPath.orElse("/"));
    }

    public String getUrlPattern() {
        if (this.swaggerBundleConfiguration.getUriPrefix() != null) {
            return this.swaggerBundleConfiguration.getUriPrefix();
        }
        String applicationContextPath = this.getApplicationContextPath();
        String rootPath = this.getJerseyRootPath();
        Object urlPattern = "/".equals(rootPath) && "/".equals(applicationContextPath) ? "/" : ("/".equals(rootPath) && !"/".equals(applicationContextPath) ? applicationContextPath : (!"/".equals(rootPath) && "/".equals(applicationContextPath) ? rootPath : applicationContextPath + rootPath));
        return urlPattern;
    }

    public String getSwaggerUriPath() {
        String jerseyRootPath = this.getJerseyRootPath();
        String uriPathPrefix = jerseyRootPath.equals("/") ? "" : jerseyRootPath;
        return uriPathPrefix + "/swagger-static";
    }

    public String getOAuth2RedirectUriPath() {
        String jerseyRootPath = this.getJerseyRootPath();
        String uriPathPrefix = jerseyRootPath.equals("/") ? "" : jerseyRootPath;
        return uriPathPrefix + "/oauth2-redirect.html";
    }

    private String getApplicationContextPath() {
        ServerFactory serverFactory = this.configuration.getServerFactory();
        String applicationContextPath = serverFactory instanceof SimpleServerFactory ? ((SimpleServerFactory)serverFactory).getApplicationContextPath() : ((DefaultServerFactory)serverFactory).getApplicationContextPath();
        return this.stripUrlSlashes(applicationContextPath);
    }

    private String stripUrlSlashes(String urlToStrip) {
        if (urlToStrip.endsWith("/*")) {
            urlToStrip = urlToStrip.substring(0, urlToStrip.length() - 1);
        }
        if (!urlToStrip.isEmpty() && urlToStrip.endsWith("/")) {
            urlToStrip = urlToStrip.substring(0, urlToStrip.length() - 1);
        }
        return urlToStrip;
    }
}

