/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.sample;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.PrincipalImpl;
import io.federecio.dropwizard.sample.Saying;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/")
@SecuritySchemes(value={@SecurityScheme(type=SecuritySchemeType.HTTP, scheme="basic"), @SecurityScheme(type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(implicit=@OAuthFlow(authorizationUrl="/oauth2/auth")))})
public class SampleResource {
    @GET
    @Path(value="/hello")
    @Produces(value={"application/json"})
    @Operation(summary="Hello", description="Returns hello", responses={@ApiResponse(responseCode="200", description="hello")})
    public Saying hello() {
        return new Saying("hello");
    }

    @GET
    @Path(value="/secret")
    @Produces(value={"application/json"})
    @Operation(summary="Secret", description="Returns secret", responses={@ApiResponse(responseCode="200", description="secret"), @ApiResponse(responseCode="401", description="Please enter basic credentials or use oauth2 authentication")})
    public Saying secret(@Parameter(hidden=true) @Auth PrincipalImpl user) {
        return new Saying(String.format("Hi %s! It's a secret message...", user.getName()));
    }
}

