/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.sample;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.federecio.dropwizard.swagger.SwaggerOAuth2Configuration;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;

@Path(value="/oauth2")
public class OAuth2Resource {
    public static final String MOCKED_OAUTH2_TOKEN = UUID.randomUUID().toString();
    private final SwaggerOAuth2Configuration oAuth2Configuration;

    public OAuth2Resource(SwaggerOAuth2Configuration oAuth2Configuration) {
        this.oAuth2Configuration = oAuth2Configuration.clone();
    }

    @GET
    @Path(value="/auth")
    @Produces(value={"application/json"})
    public Response auth(@QueryParam(value="response_type") String responseType, @QueryParam(value="client_id") @DefaultValue(value="") String clientId, @QueryParam(value="client_secret") @DefaultValue(value="") String clientSecret, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="realm") @DefaultValue(value="") String realm) throws URISyntaxException {
        try {
            Preconditions.checkArgument((boolean)clientId.equals(this.oAuth2Configuration.getClientId()), (Object)"Bad client id");
            if (!Strings.isNullOrEmpty((String)this.oAuth2Configuration.getClientSecret())) {
                Preconditions.checkArgument((boolean)clientSecret.equals(this.oAuth2Configuration.getClientSecret()), (Object)"Bad client secret");
            }
            Preconditions.checkArgument((boolean)realm.equals(this.oAuth2Configuration.getRealm()), (Object)"Bad realm");
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
        URI redirectWithAccessToken = UriBuilder.fromUri((String)redirectUri).queryParam("state", new Object[]{state}).queryParam("access_token", new Object[]{MOCKED_OAUTH2_TOKEN}).build(new Object[0]);
        return Response.seeOther((URI)redirectWithAccessToken).build();
    }
}

