/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.token_rotation;

import com.slack.api.RequestConfigurator;
import com.slack.api.Slack;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.oauth.OAuthV2AccessResponse;
import com.slack.api.token_rotation.CurrentToken;
import com.slack.api.token_rotation.RefreshedToken;
import com.slack.api.token_rotation.TokenRotationException;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;

public class TokenRotator {
    private static MethodsClient DEFAULT_METHODS_CLIENT = Slack.getInstance().methods();
    public static long DEFAULT_MILLISECONDS_BEFORE_EXPIRATION = 0x6DDD00L;
    private MethodsClient methodsClient;
    private long millisecondsBeforeExpiration;
    private String clientId;
    private String clientSecret;

    public TokenRotator(String clientId, String clientSecret) {
        this(DEFAULT_METHODS_CLIENT, DEFAULT_MILLISECONDS_BEFORE_EXPIRATION, clientId, clientSecret);
    }

    public TokenRotator(MethodsClient methodsClient, long millisecondsBeforeExpiration, String clientId, String clientSecret) {
        this.methodsClient = methodsClient;
        this.millisecondsBeforeExpiration = millisecondsBeforeExpiration;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public Optional<RefreshedToken> performTokenRotation(RequestConfigurator<CurrentToken.CurrentTokenBuilder> configurator) throws TokenRotationException {
        return this.performTokenRotation(configurator.configure(CurrentToken.builder()).build());
    }

    public Optional<RefreshedToken> performTokenRotation(CurrentToken current) throws TokenRotationException {
        if (current.getExpiresAt() > System.currentTimeMillis() + this.getMillisecondsBeforeExpiration()) {
            return Optional.empty();
        }
        try {
            OAuthV2AccessResponse refreshResponse = this.getMethodsClient().oauthV2Access(r -> r.clientId(this.getClientId()).clientSecret(this.getClientSecret()).refreshToken(current.getRefreshToken()).grantType("refresh_token"));
            if (!refreshResponse.isOk()) {
                throw new TokenRotationException("Received an error code in oauth.v2.access response body: " + refreshResponse.getError());
            }
            RefreshedToken refreshed = new RefreshedToken();
            refreshed.setAccessToken(refreshResponse.getAccessToken());
            refreshed.setRefreshToken(refreshResponse.getRefreshToken());
            refreshed.setExpiresAt(System.currentTimeMillis() + (long)(refreshResponse.getExpiresIn() * 1000));
            return Optional.of(refreshed);
        }
        catch (IOException e) {
            throw new TokenRotationException("Failed to connect to the Slack server (error: " + e.getMessage() + ")", e);
        }
        catch (SlackApiException e) {
            String message = "Received unexpected HTTP status code from the Slack server (code: " + e.getResponse().code() + ", body: " + e.getResponseBody() + ")";
            throw new TokenRotationException(message, e);
        }
    }

    @Generated
    public MethodsClient getMethodsClient() {
        return this.methodsClient;
    }

    @Generated
    public long getMillisecondsBeforeExpiration() {
        return this.millisecondsBeforeExpiration;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public void setMethodsClient(MethodsClient methodsClient) {
        this.methodsClient = methodsClient;
    }

    @Generated
    public void setMillisecondsBeforeExpiration(long millisecondsBeforeExpiration) {
        this.millisecondsBeforeExpiration = millisecondsBeforeExpiration;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenRotator)) {
            return false;
        }
        TokenRotator other = (TokenRotator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMillisecondsBeforeExpiration() != other.getMillisecondsBeforeExpiration()) {
            return false;
        }
        MethodsClient this$methodsClient = this.getMethodsClient();
        MethodsClient other$methodsClient = other.getMethodsClient();
        if (this$methodsClient == null ? other$methodsClient != null : !this$methodsClient.equals(other$methodsClient)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        return !(this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TokenRotator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $millisecondsBeforeExpiration = this.getMillisecondsBeforeExpiration();
        result = result * 59 + (int)($millisecondsBeforeExpiration >>> 32 ^ $millisecondsBeforeExpiration);
        MethodsClient $methodsClient = this.getMethodsClient();
        result = result * 59 + ($methodsClient == null ? 43 : $methodsClient.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TokenRotator(methodsClient=" + this.getMethodsClient() + ", millisecondsBeforeExpiration=" + this.getMillisecondsBeforeExpiration() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ")";
    }
}

