/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.builtin.oauth.OAuthStateErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthRedirectUriPageRenderer;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthDefaultStateErrorHandler
implements OAuthStateErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthDefaultStateErrorHandler.class);
    private final AppConfig appConfig;
    private final OAuthRedirectUriPageRenderer pageRenderer;

    public OAuthDefaultStateErrorHandler(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.pageRenderer = appConfig.getOAuthRedirectUriPageRenderer();
    }

    @Override
    public Response handle(OAuthCallbackRequest request, Response response) {
        log.warn("Invalid state parameter detected - payload: {}", (Object)request.getPayload());
        String url = request.getContext().getOauthCancellationUrl();
        if (url != null && !url.isEmpty()) {
            response.setStatusCode(302);
            response.getHeaders().put("Location", Arrays.asList(request.getContext().getOauthCancellationUrl()));
        } else {
            String reason = "invalid_state";
            response.setStatusCode(200);
            response.setBody(this.pageRenderer.renderFailurePage(this.appConfig.getOauthInstallRequestURI(), reason));
            response.setContentType("text/html; charset=utf-8");
        }
        return response;
    }
}

