/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service;

import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.Service;
import java.util.List;
import java.util.Map;

public interface OpenIDConnectNonceService
extends Service {
    default public String extractNonceFromQueryString(Request request) {
        Map<String, List<String>> queryString = request.getQueryString();
        for (String key : queryString.keySet()) {
            List<String> values;
            if (!key.equals("nonce") || (values = queryString.get(key)) == null || values.size() <= 0) continue;
            return values.get(0);
        }
        return null;
    }

    default public String issueNewNonce(Request request, Response response) throws Exception {
        String newNonce = this.generateNewNonceValue();
        this.addNewNonceToDatastore(newNonce);
        return newNonce;
    }

    public String generateNewNonceValue();

    public void addNewNonceToDatastore(String var1) throws Exception;

    default public boolean isValid(Request request) {
        String givenNonce = this.extractNonceFromQueryString(request);
        if (givenNonce == null || givenNonce.trim().isEmpty()) {
            return false;
        }
        return this.isAvailableInDatabase(givenNonce);
    }

    public boolean isAvailableInDatabase(String var1);

    default public void consume(Request request, Response response) throws Exception {
        String givenNonce = this.extractNonceFromQueryString(request);
        this.deleteNonceFromDatastore(givenNonce);
    }

    public void deleteNonceFromDatastore(String var1) throws Exception;
}

