/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.PreparationContext;
import com.schibsted.spt.data.jslt.impl.Scope;
import com.schibsted.spt.data.jslt.impl.VariableInfo;

public class VariableExpression
extends AbstractNode {
    private String variable;
    private int slot;
    private VariableInfo info;

    public VariableExpression(String variable, Location location) {
        super(location);
        this.variable = variable;
        this.slot = -1;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode value = scope.getValue(this.slot);
        if (value == null) {
            throw new JsltException("No such variable '" + this.variable + "'", this.location);
        }
        return value;
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + this);
    }

    @Override
    public void prepare(PreparationContext ctx) {
        this.info = ctx.scope.resolveVariable(this);
        this.slot = this.info.getSlot();
        this.info.incrementUsageCount();
    }

    @Override
    public ExpressionNode optimize() {
        ExpressionNode declaration = this.info.getDeclaration();
        if (declaration != null && declaration instanceof LiteralExpression) {
            return declaration;
        }
        return this;
    }

    public String toString() {
        return "$" + this.variable;
    }
}

