/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import com.schibsted.spt.data.jslt.impl.ScopeManager;
import com.schibsted.spt.data.jslt.impl.VariableInfo;
import java.util.Collections;
import java.util.List;

public class LetExpression
extends AbstractNode {
    private String variable;
    private ExpressionNode value;
    private int slot;
    private VariableInfo info;

    public LetExpression(String variable, ExpressionNode value, Location location) {
        super(location);
        this.variable = variable;
        this.value = value;
        this.slot = -1;
    }

    public String getVariable() {
        return this.variable;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        return this.value.apply(scope, input);
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        this.value.computeMatchContexts(parent);
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + "let " + this.variable + " =");
        this.value.dump(level + 1);
    }

    @Override
    public List<ExpressionNode> getChildren() {
        return Collections.singletonList(this.value);
    }

    @Override
    public ExpressionNode optimize() {
        this.value = this.value.optimize();
        return this;
    }

    public void register(ScopeManager scope) {
        this.info = scope.registerVariable(this);
        this.slot = this.info.getSlot();
    }

    public ExpressionNode getDeclaration() {
        return this.value;
    }
}

