/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.exc.ReqlDriverError;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Util {
    public static long deadline(long timeout) {
        return System.currentTimeMillis() + timeout;
    }

    public static ByteBuffer leByteBuffer(int capacity) {
        byte[] underlying = new byte[capacity];
        return ByteBuffer.wrap(underlying).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static String bufferToString(ByteBuffer buf) {
        return new String(buf.array(), StandardCharsets.UTF_8);
    }

    public static JSONObject toJSON(String str) {
        return (JSONObject)JSONValue.parse((String)str);
    }

    public static JSONObject toJSON(ByteBuffer buf) {
        InputStreamReader codepointReader = new InputStreamReader(new ByteArrayInputStream(buf.array()));
        return (JSONObject)JSONValue.parse((Reader)codepointReader);
    }

    public static <T, P> T convertToPojo(Object value, Optional<Class<P>> pojoClass) {
        return (T)(!pojoClass.isPresent() || !(value instanceof Map) ? value : Util.toPojo(pojoClass.get(), (Map)value));
    }

    public static byte[] toUTF8(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static String fromUTF8(byte[] ba) {
        return new String(ba, StandardCharsets.UTF_8);
    }

    private static <T> T toPojo(Class<T> pojoClass, Map<String, Object> map) {
        try {
            if (map == null) {
                return null;
            }
            if (!Modifier.isPublic(pojoClass.getModifiers())) {
                throw new IllegalAccessException(String.format("%s should be public", pojoClass));
            }
            Constructor[] allConstructors = pojoClass.getDeclaredConstructors();
            if (Util.getPublicParameterlessConstructors(allConstructors).count() == 1L) {
                return (T)Util.constructViaPublicParameterlessConstructor(pojoClass, map);
            }
            Constructor[] constructors = Util.getSuitablePublicParametrizedConstructors(allConstructors, map);
            if (constructors.length == 1) {
                return (T)Util.constructViaPublicParametrizedConstructor(constructors[0], map);
            }
            throw new IllegalAccessException(String.format("%s should have a public parameterless constructor or a public constructor with %d parameters", pojoClass, map.keySet().size()));
        }
        catch (IntrospectionException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReqlDriverError("Can't convert %s to a POJO: %s", map, e.getMessage());
        }
    }

    private static Stream<Constructor> getPublicParameterlessConstructors(Constructor[] constructors) {
        return Arrays.stream(constructors).filter(constructor -> Modifier.isPublic(constructor.getModifiers()) && constructor.getParameterCount() == 0);
    }

    private static Object constructViaPublicParameterlessConstructor(Class pojoClass, Map<String, Object> map) throws IllegalAccessException, InstantiationException, IntrospectionException, InvocationTargetException {
        Object pojo = pojoClass.newInstance();
        BeanInfo info = Introspector.getBeanInfo(pojoClass);
        for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
            Method writer;
            String propertyName = descriptor.getName();
            if (!map.containsKey(propertyName) || (writer = descriptor.getWriteMethod()) == null || writer.getDeclaringClass() != pojoClass) continue;
            Object value = map.get(propertyName);
            Class<?> valueClass = writer.getParameterTypes()[0];
            writer.invoke(pojo, value instanceof Map ? Util.toPojo(valueClass, (Map)value) : valueClass.cast(value));
        }
        return pojo;
    }

    private static Constructor[] getSuitablePublicParametrizedConstructors(Constructor[] allConstructors, Map<String, Object> map) {
        return (Constructor[])Arrays.stream(allConstructors).filter(constructor -> Modifier.isPublic(constructor.getModifiers()) && Util.areParametersMatching(constructor.getParameters(), map)).toArray(Constructor[]::new);
    }

    private static boolean areParametersMatching(Parameter[] parameters, Map<String, Object> values) {
        return Arrays.stream(parameters).allMatch(parameter -> values.containsKey(parameter.getName()) && values.get(parameter.getName()).getClass() == parameter.getType());
    }

    private static Object constructViaPublicParametrizedConstructor(Constructor constructor, Map<String, Object> map) throws IllegalAccessException, InstantiationException, IntrospectionException, InvocationTargetException {
        Object[] values = Arrays.stream(constructor.getParameters()).map(parameter -> {
            Object value = map.get(parameter.getName());
            return value instanceof Map ? Util.toPojo(value.getClass(), (Map)value) : value;
        }).toArray();
        return constructor.newInstance(values);
    }
}

