/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.exc.ReqlAuthError;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.gen.proto.Protocol;
import com.rethinkdb.gen.proto.Version;
import com.rethinkdb.net.Crypto;
import com.rethinkdb.net.ScramAttributes;
import com.rethinkdb.net.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Optional;
import org.json.simple.JSONObject;

public class Handshake {
    static final Version VERSION = Version.V1_0;
    static final Long SUB_PROTOCOL_VERSION = 0L;
    static final Protocol PROTOCOL = Protocol.JSON;
    private static final String CLIENT_KEY = "Client Key";
    private static final String SERVER_KEY = "Server Key";
    private final String username;
    private final String password;
    private ProtocolState state;

    private void throwIfFailure(JSONObject json) {
        if (!((Boolean)json.get((Object)"success")).booleanValue()) {
            Long errorCode = (Long)json.get((Object)"error_code");
            if (errorCode >= 10L && errorCode <= 20L) {
                throw new ReqlAuthError((String)json.get((Object)"error"));
            }
            throw new ReqlDriverError((String)json.get((Object)"error"));
        }
    }

    public Handshake(String username, String password) {
        this.username = username;
        this.password = password;
        this.state = new InitialState(username, password);
    }

    public void reset() {
        this.state = new InitialState(this.username, this.password);
    }

    public Optional<ByteBuffer> nextMessage(String response) {
        this.state = this.state.nextState(response);
        return this.state.toSend();
    }

    public boolean isFinished() {
        return this.state.isFinished();
    }

    private class HandshakeSuccess
    implements ProtocolState {
        private HandshakeSuccess() {
        }

        @Override
        public ProtocolState nextState(String response) {
            return this;
        }

        @Override
        public Optional<ByteBuffer> toSend() {
            return Optional.empty();
        }

        @Override
        public boolean isFinished() {
            return true;
        }
    }

    private class WaitingForAuthSuccess
    implements ProtocolState {
        private final byte[] serverSignature;
        private final ByteBuffer message;

        public WaitingForAuthSuccess(byte[] serverSignature, ByteBuffer message) {
            this.serverSignature = serverSignature;
            this.message = message;
        }

        @Override
        public ProtocolState nextState(String response) {
            JSONObject json = Util.toJSON(response);
            Handshake.this.throwIfFailure(json);
            ScramAttributes auth = ScramAttributes.from((String)json.get((Object)"authentication"));
            if (!MessageDigest.isEqual(auth.serverSignature(), this.serverSignature)) {
                throw new ReqlAuthError("Invalid server signature");
            }
            return new HandshakeSuccess();
        }

        @Override
        public Optional<ByteBuffer> toSend() {
            return Optional.of(this.message);
        }

        @Override
        public boolean isFinished() {
            return false;
        }
    }

    private class WaitingForAuthResponse
    implements ProtocolState {
        private final String nonce;
        private final byte[] password;
        private final ScramAttributes clientFirstMessageBare;

        WaitingForAuthResponse(String nonce, byte[] password, ScramAttributes clientFirstMessageBare) {
            this.nonce = nonce;
            this.password = password;
            this.clientFirstMessageBare = clientFirstMessageBare;
        }

        @Override
        public ProtocolState nextState(String response) {
            JSONObject json = Util.toJSON(response);
            Handshake.this.throwIfFailure(json);
            String serverFirstMessage = (String)json.get((Object)"authentication");
            ScramAttributes serverAuth = ScramAttributes.from(serverFirstMessage);
            if (!serverAuth.nonce().startsWith(this.nonce)) {
                throw new ReqlAuthError("Invalid nonce from server");
            }
            ScramAttributes clientFinalMessageWithoutProof = ScramAttributes.create().headerAndChannelBinding("biws").nonce(serverAuth.nonce());
            byte[] saltedPassword = Crypto.pbkdf2(this.password, serverAuth.salt(), serverAuth.iterationCount());
            byte[] clientKey = Crypto.hmac(saltedPassword, Handshake.CLIENT_KEY);
            byte[] storedKey = Crypto.sha256(clientKey);
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientSignature = Crypto.hmac(storedKey, authMessage);
            byte[] clientProof = Crypto.xor(clientKey, clientSignature);
            byte[] serverKey = Crypto.hmac(saltedPassword, Handshake.SERVER_KEY);
            byte[] serverSignature = Crypto.hmac(serverKey, authMessage);
            ScramAttributes auth = clientFinalMessageWithoutProof.clientProof(clientProof);
            byte[] authJson = Util.toUTF8("{\"authentication\":\"" + auth + "\"}");
            ByteBuffer message = Util.leByteBuffer(authJson.length + 1).put(authJson).put(new byte[1]);
            return new WaitingForAuthSuccess(serverSignature, message);
        }

        @Override
        public Optional<ByteBuffer> toSend() {
            return Optional.empty();
        }

        @Override
        public boolean isFinished() {
            return false;
        }
    }

    private class WaitingForProtocolRange
    implements ProtocolState {
        private final String nonce;
        private final ByteBuffer message;
        private final ScramAttributes clientFirstMessageBare;
        private final byte[] password;

        WaitingForProtocolRange(String nonce, byte[] password, ScramAttributes clientFirstMessageBare, ByteBuffer message) {
            this.nonce = nonce;
            this.password = password;
            this.clientFirstMessageBare = clientFirstMessageBare;
            this.message = message;
        }

        @Override
        public ProtocolState nextState(String response) {
            JSONObject json = Util.toJSON(response);
            Handshake.this.throwIfFailure(json);
            Long minVersion = (Long)json.get((Object)"min_protocol_version");
            Long maxVersion = (Long)json.get((Object)"max_protocol_version");
            if (SUB_PROTOCOL_VERSION < minVersion || SUB_PROTOCOL_VERSION > maxVersion) {
                throw new ReqlDriverError("Unsupported protocol version " + SUB_PROTOCOL_VERSION + ", expected between " + minVersion + " and " + maxVersion);
            }
            return new WaitingForAuthResponse(this.nonce, this.password, this.clientFirstMessageBare);
        }

        @Override
        public Optional<ByteBuffer> toSend() {
            return Optional.of(this.message);
        }

        @Override
        public boolean isFinished() {
            return false;
        }
    }

    private class InitialState
    implements ProtocolState {
        private final String nonce;
        private final String username;
        private final byte[] password;

        InitialState(String username, String password) {
            this.username = username;
            this.password = Util.toUTF8(password);
            this.nonce = Crypto.makeNonce();
        }

        @Override
        public ProtocolState nextState(String response) {
            if (response != null) {
                throw new ReqlDriverError("Unexpected response");
            }
            ScramAttributes clientFirstMessageBare = ScramAttributes.create().username(this.username).nonce(this.nonce);
            byte[] jsonBytes = Util.toUTF8("{\"protocol_version\":" + SUB_PROTOCOL_VERSION + "," + "\"authentication_method\":\"SCRAM-SHA-256\"," + "\"authentication\":" + "\"n,," + clientFirstMessageBare + "\"" + "}");
            ByteBuffer msg = Util.leByteBuffer(4 + jsonBytes.length + 1).putInt(Handshake.VERSION.value).put(jsonBytes).put(new byte[1]);
            return new WaitingForProtocolRange(this.nonce, this.password, clientFirstMessageBare, msg);
        }

        @Override
        public Optional<ByteBuffer> toSend() {
            return Optional.empty();
        }

        @Override
        public boolean isFinished() {
            return false;
        }
    }

    private static interface ProtocolState {
        public ProtocolState nextState(String var1);

        public Optional<ByteBuffer> toSend();

        public boolean isFinished();
    }
}

