/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.proto;

import java.util.Optional;

public enum ResponseType {
    SUCCESS_ATOM(1),
    SUCCESS_SEQUENCE(2),
    SUCCESS_PARTIAL(3),
    WAIT_COMPLETE(4),
    SERVER_INFO(5),
    CLIENT_ERROR(16),
    COMPILE_ERROR(17),
    RUNTIME_ERROR(18);

    public final int value;

    private ResponseType(int value) {
        this.value = value;
    }

    public static ResponseType fromValue(int value) {
        switch (value) {
            case 1: {
                return SUCCESS_ATOM;
            }
            case 2: {
                return SUCCESS_SEQUENCE;
            }
            case 3: {
                return SUCCESS_PARTIAL;
            }
            case 4: {
                return WAIT_COMPLETE;
            }
            case 5: {
                return SERVER_INFO;
            }
            case 16: {
                return CLIENT_ERROR;
            }
            case 17: {
                return COMPILE_ERROR;
            }
            case 18: {
                return RUNTIME_ERROR;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a legal value for ResponseType", value));
    }

    public static Optional<ResponseType> maybeFromValue(int value) {
        try {
            return Optional.of(ResponseType.fromValue(value));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }

    public boolean isError() {
        switch (this) {
            case CLIENT_ERROR: {
                return true;
            }
            case COMPILE_ERROR: {
                return true;
            }
            case RUNTIME_ERROR: {
                return true;
            }
        }
        return false;
    }
}

