/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.proto;

import java.util.Optional;

public enum QueryType {
    START(1),
    CONTINUE(2),
    STOP(3),
    NOREPLY_WAIT(4),
    SERVER_INFO(5);

    public final int value;

    private QueryType(int value) {
        this.value = value;
    }

    public static QueryType fromValue(int value) {
        switch (value) {
            case 1: {
                return START;
            }
            case 2: {
                return CONTINUE;
            }
            case 3: {
                return STOP;
            }
            case 4: {
                return NOREPLY_WAIT;
            }
            case 5: {
                return SERVER_INFO;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a legal value for QueryType", value));
    }

    public static Optional<QueryType> maybeFromValue(int value) {
        try {
            return Optional.of(QueryType.fromValue(value));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }
}

