/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.exc;

import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.exc.ReqlRuntimeError;
import com.rethinkdb.model.Backtrace;
import java.util.Optional;

public class ReqlInternalError
extends ReqlRuntimeError {
    Optional<Backtrace> backtrace = Optional.empty();
    Optional<ReqlAst> term = Optional.empty();

    public ReqlInternalError() {
    }

    public ReqlInternalError(String message) {
        super(message);
    }

    public ReqlInternalError(String format, Object ... args) {
        super(String.format(format, args));
    }

    public ReqlInternalError(String message, Throwable cause) {
        super(message, cause);
    }

    public ReqlInternalError(Throwable cause) {
        super(cause);
    }

    public ReqlInternalError(String msg, ReqlAst term, Backtrace bt) {
        super(msg);
        this.backtrace = Optional.ofNullable(bt);
        this.term = Optional.ofNullable(term);
    }

    @Override
    public ReqlInternalError setBacktrace(Backtrace backtrace) {
        this.backtrace = Optional.ofNullable(backtrace);
        return this;
    }

    @Override
    public Optional<Backtrace> getBacktrace() {
        return this.backtrace;
    }

    @Override
    public ReqlInternalError setTerm(ReqlAst term) {
        this.term = Optional.ofNullable(term);
        return this;
    }

    @Override
    public Optional<ReqlAst> getTerm() {
        return this.term;
    }
}

