/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.exc;

import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.model.Backtrace;
import java.util.Optional;

public class ReqlCompileError
extends ReqlError {
    Optional<Backtrace> backtrace = Optional.empty();
    Optional<ReqlAst> term = Optional.empty();

    public ReqlCompileError() {
    }

    public ReqlCompileError(String message) {
        super(message);
    }

    public ReqlCompileError(String format, Object ... args) {
        super(String.format(format, args));
    }

    public ReqlCompileError(String message, Throwable cause) {
        super(message, cause);
    }

    public ReqlCompileError(Throwable cause) {
        super(cause);
    }

    public ReqlCompileError(String msg, ReqlAst term, Backtrace bt) {
        super(msg);
        this.backtrace = Optional.ofNullable(bt);
        this.term = Optional.ofNullable(term);
    }

    @Override
    public ReqlCompileError setBacktrace(Backtrace backtrace) {
        this.backtrace = Optional.ofNullable(backtrace);
        return this;
    }

    @Override
    public Optional<Backtrace> getBacktrace() {
        return this.backtrace;
    }

    @Override
    public ReqlCompileError setTerm(ReqlAst term) {
        this.term = Optional.ofNullable(term);
        return this;
    }

    @Override
    public Optional<ReqlAst> getTerm() {
        return this.term;
    }
}

