/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.UnsafeArg;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class QosException
extends RuntimeException {
    private QosException(String message) {
        super(message);
    }

    private QosException(String message, Throwable cause) {
        super(message, cause);
    }

    public abstract <T> T accept(Visitor<T> var1);

    public static Throttle throttle() {
        return new Throttle(Optional.empty());
    }

    public static Throttle throttle(Throwable cause) {
        return new Throttle(Optional.empty(), cause);
    }

    public static Throttle throttle(Duration duration) {
        return new Throttle((Optional)Optional.of(duration));
    }

    public static Throttle throttle(Duration duration, Throwable cause) {
        return new Throttle(Optional.of(duration), cause);
    }

    public static RetryOther retryOther(URL redirectTo) {
        return new RetryOther(redirectTo);
    }

    public static RetryOther retryOther(URL redirectTo, Throwable cause) {
        return new RetryOther(redirectTo, cause);
    }

    public static Unavailable unavailable() {
        return new Unavailable();
    }

    public static Unavailable unavailable(Throwable cause) {
        return new Unavailable(cause);
    }

    public static final class Unavailable
    extends QosException
    implements SafeLoggable {
        private static final String SERVER_UNAVAILABLE = "Server unavailable";

        private Unavailable() {
            super(SERVER_UNAVAILABLE);
        }

        private Unavailable(Throwable cause) {
            super(SERVER_UNAVAILABLE, cause);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public String getLogMessage() {
            return SERVER_UNAVAILABLE;
        }

        public List<Arg<?>> getArgs() {
            return Collections.emptyList();
        }
    }

    public static final class RetryOther
    extends QosException
    implements SafeLoggable {
        private final URL redirectTo;

        private RetryOther(URL redirectTo) {
            super("Suggesting request retry against: " + redirectTo.toString());
            this.redirectTo = redirectTo;
        }

        private RetryOther(URL redirectTo, Throwable cause) {
            super("Suggesting request retry against: " + redirectTo.toString(), cause);
            this.redirectTo = redirectTo;
        }

        public URL getRedirectTo() {
            return this.redirectTo;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public String getLogMessage() {
            return this.getClass().getSimpleName() + ": Requesting retry";
        }

        public List<Arg<?>> getArgs() {
            return Collections.singletonList(UnsafeArg.of((String)"redirectTo", (Object)this.redirectTo));
        }
    }

    public static final class Throttle
    extends QosException
    implements SafeLoggable {
        private final Optional<Duration> retryAfter;

        private Throttle(Optional<Duration> retryAfter) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter);
            this.retryAfter = retryAfter;
        }

        private Throttle(Optional<Duration> retryAfter, Throwable cause) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter, cause);
            this.retryAfter = retryAfter;
        }

        public Optional<Duration> getRetryAfter() {
            return this.retryAfter;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public String getLogMessage() {
            return "Suggested request throttling";
        }

        public List<Arg<?>> getArgs() {
            return Collections.singletonList(SafeArg.of((String)"retryAfter", (Object)this.retryAfter.orElse(null)));
        }
    }

    public static interface Visitor<T> {
        public T visit(Throttle var1);

        public T visit(RetryOther var1);

        public T visit(Unavailable var1);
    }
}

